/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int STdec1long (const char String[], long int *Lval)

Purpose:
  Decode a long integer value

Description:
  This routine decodes a string containing a numeric value.  The decoded datum
  is stored as a long integer value.  If a decoding error is detected, a
  warning message is printed and an error status value is returned.  A warning
  message is printed if extra data follows the requested value (this data is
  ignored).

Parameters:
  <-  int STdec1long
      Error status, 0 for no error, 1 for error
   -> const char String[]
      Input string
  <-  long int *Lval
      Returned value.  This value is not changed if an error status is
      returned.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.2 $  $Date: 1996/05/31 19:09:01 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdec1long.c 1.2 1996/05/31 libtsp-V2R7a $";

#include <libtsp.h>
#include <libtsp/nucleus.h>

int
STdec1long (String, Lval)

     const char String[];
     long int *Lval;

{
  return (STdec1val (String, 'L', (void *) Lval));
}
