/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  long int MSlCeil (long n, long m)

Purpose:
  Ceiling function for the ratio of two long ints

Description:
  This routine calculates the ceiling function of the ratio n/m.  It returns
  the smallest integer that is greater than or equal to the quotient.

Parameters:
  <-  long int MSlCeil
      Returned integer value
   -> long int n
      Input value (numerator)
   -> long int m
      Input value (denominator)

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.1 $  $Date: 1995/05/04 09:32:06 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: MSlCeil.c 1.1 1995/05/04 libtsp-V2R7a $";

#include <libtsp.h>

long int
MSlCeil (n, m)

     long int n;
     long int m;

{
  long int q;

/*
   For positive operands, the ceiling function is just (n-1)/m + 1.  However,
   if n and/or m is negative, the result of integer division may not truncate
   towards zero.  Consider
     q = (n-r)/m, where q = [n/m] (integer division) and r = n % m.
   The ceiling function is then either q or q+1, depending on the sign of r
   and m.
*/
  q = n / m;
  if (m > 0) {
    if (n <= m * q)
      return q;
    else
      return q + 1;
  }
  else {
    if (n >= m * q)
      return q;
    else
      return q + 1;
  }
}
