/*------------ Telecommunications & Signal Processing Lab -------------
                         McGill University

Routine:
  int FLterm (FILE *fp)

Purpose:
  Determine if a file pointer is associated with a terminal

Description:
  This subroutine determines if a file specified by its file pointer is
  associated with a terminal device.

Parameters:
  <-  int FLterm
      Return value, 1 for a terminal, 0 otherwise
   -> FILE *fp
      File pointer

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.1 $  $Date: 1995/05/20 10:13:16 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLterm.c 1.1 1995/05/20 libtsp-V2R7a $";

#include <stdio.h>		/* fileno */
#include <libtsp/nucleus.h>

#ifdef _MSDOS
#  ifndef MSDOS
#    define MSDOS 1	/* For MSVC with /Za option */
#  endif
#endif

#ifdef MSDOS
#  ifndef unix
#    define USE__NAME
#  endif
#endif

#ifdef USE__NAME
#  include <io.h>
#  define FILENO	_fileno
#  define ISATTY	_isatty
#else
#  include <unistd.h>
#  define FILENO	fileno
#  define ISATTY	isatty
#endif

int
FLterm (fp)

     FILE *fp;

{
  return ISATTY (FILENO (fp));
}
