/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Routine:
  int FLpreName (const char Fname[], char Pname[])

Purpose:
  Return the last component of a file name stripped of its extension

Description:
  This routine takes a filename and returns the last component of the filename
  stripped of the filename extension.  The extension is the part of the last
  component of the path name beginning with (and including) a period.  The
  string returned for a path name "/abc/def.ghi" is "def".

Parameters:
  <-  int FLpreName
      Number of characters in the output string
   -> const char Fname[]
      Input character string with the file name
  <-  char Pname[]
      Output string filename string without the extension.  This string is at
      most FILENAME_MAX characters long not including the terminating null
      character.

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.2 $  $Date: 1995/05/12 11:27:10 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLpreName.c 1.2 1995/05/12 libtsp-V2R7a $";

#include <string.h>
#include <libtsp.h>

int
FLpreName (Fname, Pname)

     const char Fname[];
     char Pname[];

{
  char *p;
  int n;
  char Bname[FILENAME_MAX];

  FLbaseName (Fname, Bname);
  p = strchr (Bname, '.');
  if (p != NULL)
    *p = '\0';
  n = STcopyMax (Bname, Pname, FILENAME_MAX);

  return n;
}
