/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Routine:
  int FLbaseName (const char Fname[], char Bname[])

Purpose:
  Return the last component of a file path

Description:
  This routine takes a file path specification and returns the rightmost
  component.  Components are separated by / characters.  If no / character
  appears in the path, the input path name is returned.  For MS-DOS, the
  directory separator character is \.

Parameters:
  <-  int FLbaseName
      Number of characters in the output string
   -> const char Fname[]
      Input character string with the path name
  <-  char Bname[]
      Output string with the last path name component.  This string is at
      most FILENAME_MAX characters long not including the terminating null
      character.

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.11 $  $Date: 1995/05/20 09:44:39 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLbaseName.c 1.11 1995/05/20 libtsp-V2R7a $";

#include <string.h>
#include <libtsp.h>

#ifdef _MSDOS
#  ifndef MSDOS
#    define MSDOS	1	/* For MSVC with /Za option */
#  endif
#endif

#ifdef MSDOS
#  ifndef unix
#    define MSDOS_SEP
#  endif
#endif

#ifdef MSDOS_SEP
#  define DIR_SEP_CHAR		'\\'
#else
#  define DIR_SEP_CHAR		'/'
#endif

int
FLbaseName (Fname, Bname)

     const char Fname[];
     char Bname[];

{
  char *p;
  int n;

  p = strrchr (Fname, DIR_SEP_CHAR);
  if (p != NULL)
    n = STcopyMax (p+1, Bname, FILENAME_MAX);
  else
    n = STcopyMax (Fname, Bname, FILENAME_MAX);

  return n;
}
