/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  UTtypes.h

Description:
  Type declarations for size dependent storage elements

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.6 $  $Date: 1995/05/02 08:05:43 $

----------------------------------------------------------------------*/

#ifndef UTtypes_h_
#define UTtypes_h_

#include <limits.h>

typedef double double8_t;		/* 8-byte double */
typedef float float4_t;			/* 4-byte float */

/* Assume that the lengths of (short int, int, long int) are (2,2,4), (2,4,4)
   or (2,4,8) bytes */
#if (INT_MAX == SHRT_MAX)
  typedef unsigned long int uint4_t;	/* 4-byte unsigned int */
  typedef long int int4_t;		/* 4-byte int */
#else
  typedef unsigned int uint4_t;		/* 4-byte unsigned int */
  typedef int int4_t;			/* 4-byte int */
#endif

typedef unsigned short int uint2_t;	/* 2-byte unsigned int */
typedef short int int2_t;		/* 2-byte int */
typedef unsigned char uint1_t;		/* 1-byte unsigned int */

#endif	/* UTtypes_h_ */
