*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE WRTINT (NAMEFL, H, NTAP, IR, F, PSD, NVAL)
*
*
* Purpose:
*     Write an interpolating filter coefficient file
*
*
* Description:
*     This subroutine writes a coefficient file for an FIR filter.  The
*     coefficient file is created and written to as unit number 3.  The
*     data written to the file includes a header containing the design
*     specification.  This is followed by the filter coefficients.  The
*     file is then closed.  The file name is also printed.
*
*
* Parameters:
* C ->  NAMEFL - File name for the coefficient file.  If the name is
*                all blank, no file is written.
* R ->  H      - Array of coefficients (NTAP values)
* I ->  NTAP   - Number of filter coefficients
* I ->  IR     - Interpolating ratio
* R ->  F      - Array of normalized frequencies.  The frequency values
*                must be non-negative. The normalizing frequency is the
*                frequency of the input sequence before interpolation.
*                The first NVAL(1) values must be in increasing order.
*                These are the frequencies of samples of the continuous
*                power spectral density.  The next NVAL(2) values are
*                the frequencies of the sinusoidal components.
* R ->  PSD    - Array of power spectral values. The value PSD(i) gives
*                the power spectrum at frequency F(i). Each PSD(i) must
*                be non-negative.  The first NVAL(1) values are samples
*                of the continuous power spectral density.  The next
*                NVAL(2) values are the powers of the sinusoidal
*                components.
* I ->  NVAL   - Number of frequency and power spectrum values.  This
*                is a two element array.  NVAL(1) gives the number of
*                samples of the continuous power spectrum (at least 2).
*                NVAL(2) gives the number of sinusoidal components.
*
*
* Routines required:
*     LENSTR - Find the length of a whitespace terminated string
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.4 $  $Date: 1993/01/25 05:38:58 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE WRTINT (NAMEFL, H, NTAP, IR, F, PSD, NVAL)


      INTEGER ICFF
      PARAMETER (ICFF=3)

      CHARACTER*(*) NAMEFL,FULLNM*255

      INTEGER NTAP,IR,NVAL(2)
      INTEGER NC,I,NCHR
      INTEGER LENSTR

      REAL H(0:NTAP-1),F(*),PSD(*)


      NC=LENSTR(NAMEFL)
      IF (NC.GT.0) THEN
        OPEN (UNIT=ICFF,FILE=NAMEFL(1:NC),STATUS='NEW')
        INQUIRE (UNIT=ICFF,NAME=FULLNM)

        WRITE (UNIT=ICFF,FMT=3000) 'Interpolating Filter'
        WRITE (UNIT=ICFF,FMT=3100) IR
        WRITE (UNIT=ICFF,FMT=3200)
        WRITE (UNIT=ICFF,FMT=3300) ('Freq.   Value',
     -                              I=1,MIN(3,MAX(NVAL(1),NVAL(2))))
        IF (NVAL(1).GT.0)
     -    WRITE (UNIT=ICFF,FMT=3400) (F(I),PSD(I),I=1,NVAL(1))
        IF (NVAL(2).GT.0)
     -    WRITE (UNIT=ICFF,FMT=3500) (F(I),PSD(I),
     -                                I=NVAL(1)+1,NVAL(1)+NVAL(2))
        WRITE (UNIT=ICFF,FMT=3600) (H(I),I=0,NTAP-1)

        CLOSE (UNIT=ICFF)
        NCHR=LENSTR(FULLNM)
        WRITE (UNIT=*,FMT=2000) FULLNM(1:NCHR)
      END IF


      RETURN

 2000 FORMAT (/' Coefficient file: ',A)
 3000 FORMAT ('!FIR - ',A)
 3100 FORMAT ('! Interpolating Ratio:',I4)
 3200 FORMAT ('! Power Spectrum:')
 3300 FORMAT ('!',4X,A,:,13X,A,:,13X,A)
 3400 FORMAT ('!',0PF9.5,1PG12.4,0PF14.5,1PG12.4,0PF14.5,1PG12.4)
 3500 FORMAT ('!',0PF9.5, 1PG12.4,' cos',
     -            0PF10.5,1PG12.4,' cos'
     -            0PF10.5,1PG12.4,' cos')
 3600 FORMAT (1PE15.6,1PE15.6,1PE15.6,1PE15.6,1PE15.6)

      END
