*---------------------------INRS-Telecommunications---------------------------
*
*
* MODULE:
*	SUBROUTINE LINEIN (PROMPT, LINE, NCHR, IEOF)
*
*
* PURPOSE:
*	This subroutine retrieves a line of input.
*
*
* DESCRIPTION:
*	This subroutine reads lines of input. A prompt message is also
*	printed if the standard input is associated with a terminal.
*
*
* PARAMETERS:
* C ->	PROMPT - Character string used as a prompt
* C <-	LINE   - Character string for the input line. If the length of
*	         LINE is insufficient for input line, the input line
*	         is truncated. For input lines shorter than the length
*	         of LINE, LINE is padded out with blanks.
* I <-	NCHR   - Number of characters in the line. NCHR is set to 0 on
*	         reaching end-of-file.
* I <-	IEOF   - End-of-file flag,
*	          0  - Normal value
*	         -1  - End-of-file
*
*
* ROUTINES REQUIRED:
*	LIB$GET_INPUT - System routine to prompt and read a line
*	PSYMSG - Print a system message
*
*
* AUTHOR / MAINTAINED BY:
*	P. Kabal
*
*
* DATE CREATED:
*	1987/11/23
*
*
* UPDATES:
*	1988/08/09  VAX/VMS version
*
*
*---------------------------INRS-Telecommunications---------------------------

	SUBROUTINE LINEIN (PROMPT, LINE, NCHR, IEOF)


	CHARACTER*(*) PROMPT,LINE

	INTEGER*2 LLEN

	EXTERNAL RMS$_EOF


* Write a prompt if the input is from a terminal
	ISTAT=LIB$GET_INPUT(LINE,PROMPT,LLEN)
	NCHR=LLEN

* Check the error status
	IF (ISTAT.EQ.%LOC(RMS$_EOF)) THEN
	  IEOF=-1
	  NCHR=0
	ELSE
	  IEOF=0
	  IF (.NOT.ISTAT) CALL PSYMSG(ISTAT)
	END IF


	RETURN

	END
