*---------------------------INRS-Telecommunications---------------------------
*
*
* MODULE:
*	SUBROUTINE HALT (STRING)
*
*
* PURPOSE:
*	This routine prints an error message and terminates a program
*	with a system error code set.
*
*
* DESCRIPTION:
*	This routine signals a fatal error message FOR_F_ABORT and an
*	informational message FOR_I_TEXT with the given text. The
*	default action is to halt program execution on the signalling
*	of the fatal error. If other types of actions are desired, a
*	condition handler must be declared.
*
*
* PARAMETERS:
* C ->	STRING - Character string to be printed
*
*
* ROUTINES REQUIRED:
*	GETIMG - Get the image name
*	LIB$SIGNAL - Signal an error
*
*
* AUTHOR / MAINTAINED BY:
*	P. Kabal
*
*
* DATE CREATED:
*	1983/04/29
*
*
* UPDATES:
*	1986/09/08  Use system file name parsing
*	1989/04/04  Use GETIMG
*
*
*---------------------------INRS-Telecommunications---------------------------

	SUBROUTINE HALT (STRING)
 
 
	INTEGER FOR_I_TEXT,FOR_F_ABORT
	PARAMETER (FOR_I_TEXT='181133'X,FOR_F_ABORT='1810DC'X)
 
	CHARACTER STRING*(*),IMAGE_NAME*255
 
 
* Get the image name
	CALL GETIMG(IMAGE_NAME,NCN)
 
* Terminate the program and signal the message text as informational text
	CALL LIB$SIGNAL(%VAL(FOR_F_ABORT),%VAL(1),
     -	                IMAGE_NAME(1:NCN),
     -	                %VAL(FOR_I_TEXT),%VAL(1),STRING)
 
	END
