*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PRTINT (IR, ERR2, F, PSD, NVAL)
*
*
* Purpose:
*     Print interpolating filter design parameters
*
*
* Description:
*     This subroutine prints the specifications and resulting error for
*     an interpolating FIR filter.
*
*
* Parameters:
* I ->  IR     - Interpolating ratio
* R ->  ERR2   - Mean-square error
* R ->  F      - Array of normalized frequencies.  The frequency values
*                must be non-negative. The normalizing frequency is the
*                frequency of the input sequence before interpolation.
*                The first NVAL(1) values must be in increasing order.
*                These are the frequencies of samples of the continuous
*                power spectral density.  The next NVAL(2) values are
*                the frequencies of the sinusoidal components.
* R ->  PSD    - Array of power spectral values. The value PSD(i) gives
*                the power spectrum at frequency F(i). Each PSD(i) must
*                be non-negative.  The first NVAL(1) values are samples
*                of the continuous power spectral density.  The next
*                NVAL(2) values are the powers of the sinusoidal
*                components.
* I ->  NVAL   - Number of frequency and power spectrum values.  This
*                is a two element array.  NVAL(1) gives the number of
*                samples of the continuous power spectrum (at least 2).
*                NVAL(2) gives the number of sinusoidal components.
*
*
* Routines required:
*     None
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 05:26:40 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PRTINT (IR, ERR2, F, PSD, NVAL)


      INTEGER IR,NVAL(2)
      INTEGER I

      REAL ERR2
      REAL DB,X
      REAL DBERR
      REAL F(*),PSD(*)

* Statement function to convert to decibels
      DB(X)=10.0*LOG10(x)


* Title
      WRITE (UNIT=*,FMT=2000) 'Interpolating Filter:'
      DBERR=1E20
      IF (ERR2.GT.0.0) DBERR=-DB(ERR2)
      WRITE (UNIT=*,FMT=2100) IR
      WRITE (UNIT=*,FMT=2200)
      IF (NVAL(1).GT.0) THEN
        WRITE (UNIT=*,FMT=2300) (F(I),PSD(I),I=1,NVAL(1))
      END IF
      IF (NVAL(2).GT.0) THEN
        WRITE (UNIT=*,FMT=2400) (F(I),PSD(I),
     -                           I=NVAL(1)+1,NVAL(1)+NVAL(2))
      END IF
      WRITE (UNIT=*,FMT=2500) DBERR


      RETURN

 2000 FORMAT (/1X,A)
 2100 FORMAT (' Interpolating ratio:',I4)
 2200 FORMAT (' Power Spectrum:'/
     -        '    Freq.    Value')
 2300 FORMAT (' ',0PF9.5,1PG12.4)
 2400 FORMAT (' ',0PF9.5,1PG12.4,' cos')
 2500 FORMAT (' SNR:',F7.2,' dB')

      END
