*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PRTCOF (ITYPE, H, NTAP)
*
*
* Purpose:
*     Print FIR filter coefficients
*
*
* Description:
*     This subroutine prints filter coefficients.
*
*
* Parameters:
* I ->  ITYPE  - Filter type coded as follows.
*                1 - Multiple passband/stopband filter
*                2 - Multiple passband/stopband filter
*                    (sin(X)/X compensation)
*                3 - Differentiator
*                4 - Hilbert transform filter
*                5 - Interpolating filter
*                6 - Nyquist filter
*                7 - Minimum phase factor of a Nyquist filter
* R ->  H      - Array of filter coefficients.  The filter coefficients
*                are assumed to be symmetric for types 1, 2, 5, and 6
*                and anti-symmetric for types 3 and 4.
* I ->  NTAP   - Number of filter coefficients
*
*
* Routines required:
*     None
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.4 $  $Date: 1993/02/03 04:53:48 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PRTCOF (ITYPE, H, NTAP)


      INTEGER NKEY,BPF,REC,DIF,HIL,INT,NYQ,MPH
      PARAMETER (NKEY=7,BPF=1,REC=2,DIF=3,HIL=4,INT=5,NYQ=6,MPH=7)

      CHARACTER FLTTYP(NKEY)*40

      INTEGER ITYPE,NTAP
      INTEGER I

      REAL H(0:NTAP-1)

      DATA FLTTYP/'Bandpass Filter:',
     -            'Bandpass Filter (sin(x)/x compensation):',
     -            'Differentiator:',
     -            'Hilbert Transform Filter:',
     -            'Interpolating Filter:',
     -            'Nyquist Filter:',
     -            'Minimum Phase Factor of a Nyquist Filter:'/


      IF (ITYPE.NE.MPH) THEN
        WRITE (UNIT=*,FMT=2000)
        WRITE (UNIT=*,FMT=2200) FLTTYP(ITYPE)
        DO 100 I=0,NTAP/2-1
          IF (ITYPE.EQ.DIF .OR. ITYPE.EQ.HIL) THEN
            WRITE (UNIT=*,FMT=2300) I,H(I),NTAP-I-1
          ELSE
            WRITE (UNIT=*,FMT=2400) I,H(I),NTAP-I-1
          END IF
 100    CONTINUE
        IF (MOD(NTAP,2).NE.0) WRITE (UNIT=*,FMT=2300) I,H(I)

      ELSE
        WRITE (UNIT=*,FMT=2100)
        WRITE (UNIT=*,FMT=2200) FLTTYP(ITYPE)
        DO 200 I=0,NTAP-2,2
          WRITE (UNIT=*,FMT=2500) I,H(I),I+1,H(I+1)
 200    CONTINUE
        IF (MOD(NTAP,2).NE.0)
     -    WRITE (UNIT=*,FMT=2500) NTAP-1,H(NTAP-1)

      END IF


      RETURN

 2000 FORMAT (/' Linear Phase FIR Filter Design')
 2100 FORMAT (/' FIR Filter Design')
 2200 FORMAT (1X,A)
 2300 FORMAT ('  H(',I3,') =',1PE15.6,:,' = -H(',I3,')')
 2400 FORMAT ('  H(',I3,') =',1PE15.6,:,' = H(',I3,')')
 2500 FORMAT ('  H(',I3,') =',1PE15.6,:,'    H(',I3,') =',1PE15.6)

      END
