*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE RQUOTE (LINE, STROUT, NC)
*
*
* Purpose:
*     Copy a string, removing outer quotes
*
*
* Description:
*     This routine processes a character string.  Leading and trailing
*     blanks, tabs and null characters are removed from the string.
*     Within quotes ("), any characters are permissible.  Any outer
*     paired quotes are removed. Two adjacent quote characters within
*     a quoted string are collapsed to become single quote character.
*
*
* Parameters:
* C ->  LINE   - Input string
* C <-  STROUT - Output string.  The output string is padded with
*                blanks.
* I <-  NC     - Number of characters in the output string, not
*                including padding blanks
*
*
* Routines required:
*     HALT   - Print an error message, stop with error status set
*     LENSTR - Find the length of a whitespace terminated string
*     LOCNBL - Find the first non-whitespace character in a string
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 00:13:13 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE RQUOTE (LINE, STROUT, NC)


      INTEGER NC
      INTEGER LS,K,I,L
      INTEGER LENSTR,LOCNBL

      LOGICAL INQUOT

      CHARACTER*(*) LINE,STROUT


* Initialization
      LS=LEN(STROUT)
      INQUOT=.FALSE.

* Skip over leading and trailing blanks, nulls and tabs
      K=LENSTR(LINE)
      I=LOCNBL(LINE(1:K))

* If the whole string is within quotes, strip off outer quotes
      IF (I.LT.K) THEN
        IF (LINE(I:I).EQ.'"' .AND. LINE(K:K).EQ.'"') THEN
          K=K-1
          I=I+1
          INQUOT=.TRUE.
        END IF
      END IF

      IF (INQUOT) THEN

* Collapse adjacent pairs of quote characters within a quoted string
        NC=0
 100    IF (I.LE.K) THEN
          L=INDEX(LINE(I:K),'""')+I-1
          IF (L.EQ.I-1) L=K
          IF (NC.LT.LS) STROUT(NC+1:)=LINE(I:L)
          NC=NC+L-I+1
          I=L+2
        GO TO 100
        END IF

      ELSE

* Copy the string directly to the output string
        NC=K-I+1
        IF (NC.GT.0) STROUT=LINE(I:K)

      END IF

* Check the string length
      IF (NC.LE.0) THEN
        STROUT=' '
      ELSE IF (NC.GT.LS) THEN
        CALL HALT('RQUOTE - String truncated')
        NC=LS
      END IF


      RETURN

      END
