*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE RDCSTR (LINE, MINN, MAXN, ASTR, N)
*
*
* Purpose:
*     Separate comma/whitespace delimited substrings
*
*
* Description:
*     This routine decodes a string containing character data.
*     Multiple data items in the string are separated by commas or
*     white space (blanks, tabs or null characters).  Within paired
*     double quote characters ("), any characters are permitted.  If
*     the number of output strings is less than the given minimum
*     number, an error message is printed and N is set to zero.
*
*     For each output string, leading and trailing white space is
*     removed.  Within quotes, any characters are permitted (two
*     adjacent quote characters within a quoted string are interpreted
*     as a single quote character).  Any outer paired quotes are
*     removed from each output string.
*
*
* Parameters:
* C ->  LINE   - Input string
* I ->  MINN   - Minimum number of values to be read (may be zero)
* I ->  MAXN   - Maximum number of values to be read (at most 256)
* C <-  ASTR   - Array of MAXN elements used to store the character
*                strings.  A null character is used to mark the end of
*                the character data in each array element if the string
*                is shorter than the length of ASTR.  Only the first N
*                elements of ASTR are modified.  If an error condition
*                is detected, the array ASTR is not modified.  An error
*                condition occurs if too few values are specified.
* I <-  N      - Actual number of values read.  If an error condition
*                is detected, N is set to zero.  An error condition
*                occurs if too few values are specified.  N is also set
*                to zero if the number of values to be read is allowed
*                to be zero and the input string contains only white
*                space.
*
*
* Routines required:
*     FNDSUB - Find comma/whitespace delimited substrings in a string
*     RQUOTE - Copy a string, removing outer quotes
*     WARN   - Print a warning message on the standard error unit
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 00:05:58 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE RDCSTR (LINE, MINN, MAXN, ASTR, N)


      INTEGER MXMAXN,IOPT
      PARAMETER (MXMAXN=256,IOPT=1)

      INTEGER MINN,MAXN,N
      INTEGER M,I,IS,IE,NC
      INTEGER IST(MXMAXN+1),IFN(MXMAXN+1)

      CHARACTER*(*) LINE,ASTR(MAXN)


* Find the substrings
      CALL FNDSUB(LINE,IOPT,IST,IFN,MXMAXN+1,M)

* Check the number of values found
      N=0
      IF (M.LT.MINN) THEN
        CALL WARN('RDCSTR - Error, too few data values')

      ELSE IF (M.GT.MXMAXN .AND. MAXN.GT.MXMAXN) THEN
        CALL WARN('RDCSTR - Error, too many data values')

      ELSE

        IF (M.GT.MAXN) THEN
          CALL WARN('RDCSTR - Warning, extra data ignored')
          M=MAXN
        END IF

* Copy the substrings, removing outer quotes
        DO 220 I=1,M
          IS=IST(I)
          IE=IFN(I)
          IF (IS.LE.IE) THEN
            CALL RQUOTE(LINE(IS:IE),ASTR(I),NC)
            IF (NC.LT.LEN(ASTR(I)))
     -        ASTR(I)(NC+1:NC+1)=CHAR(0)
          ELSE
            ASTR(I)=CHAR(0)
          END IF
 220    CONTINUE
        N=M
      END IF


      RETURN

      END
