*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE FNDSUB (LINE, IOPT, IST, IFN, MAXN, N)
*
*
* Purpose:
*     Find comma/whitespace delimited substrings in a string
*
*
* Description:
*     This routine finds substrings in a given string.  Substrings
*     are separated by commas or white space (blanks, tabs or null
*     characters). A warning message is printed if the maximum number
*     of substrings is found and data follows the last item found. For
*     each output substring, leading and trailing white space is
*     removed.
*
*     Optionally double quote characters (") or paired parentheses can
*     be used to allow white space and commas to appear in the string
*     without acting as separators.
*
*
* Parameters:
* C ->  LINE   - Input string
* I ->  IOPT   - Integer option value,
*                0 - normal operation
*                1 - quoted strings: treat characters within paired
*                    double quote characters (") as non-separators
*                2 - parenthesized strings: treat characters within
*                    paired parentheses as non-separators
*                3 - quoted strings and parenthesized strings: treat
*                    characters within paired double quote characters
*                    or paired parentheses as non-separators.  With
*                    this option, parentheses within quotes are treated
*                    in the same way as any other characters.
* I ->  MAXN   - Maximum permissible value for N
* I <-  IST    - Array of integer pointers (N values).  Element IST(i)
*                points to the start of substring i. Note that the last
*                element IST(N) will point to LEN(STRING)+1 if the last
*                substring is null.
* I <-  IFN    - Array of integer pointers (N values).  Element IFN(i)
*                points to the end of substring i.  Note that the first
*                element IFN(1) can point to 0 if the first substring
*                is null.
* I <-  N      - Number of substrings found.  Some of these substrings
*                may be null.  A null substring is signalled by having
*                IFN(i)=IST(i)-1 for substring i.
*
*
* Routines required:
*     GTPSTR - Parse a string with a separator (with white space)
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 00:16:34 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE FNDSUB (LINE, IOPT, IST, IFN, MAXN, N)


      INTEGER IOPT,MAXN,N
      INTEGER IST(MAXN),IFN(MAXN)
      INTEGER ISEP,NCHR,IPTR,IS1,IE1

      CHARACTER*(*) LINE


* Initialization
      N=0
      ISEP=0
      NCHR=LEN(LINE)

 100  IF (ISEP.LT.NCHR .AND. N.LT.MAXN) THEN

* Find a separator not within quotes
        IPTR=ISEP+1
        CALL GTPSTR(LINE(IPTR:),',',IOPT,IS1,IE1,ISEP)
        IS1=IS1+IPTR-1
        IE1=IE1+IPTR-1
        ISEP=ISEP+IPTR-1

* Save the pointers to the string
        IF (IS1.LE.IE1 .OR. ISEP.LE.NCHR) THEN
          N=N+1
          IST(N)=IS1
          IFN(N)=IE1
        END IF

      GO TO 100
      END IF

* String exhausted, check for a final null substring
      IF (NCHR.GT.0 .AND. N.LT.MAXN .AND. ISEP.EQ.NCHR) THEN
        N=N+1
        IST(N)=NCHR+1
        IFN(N)=NCHR
      END IF


      RETURN

      END
