*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     INTEGER FUNCTION LENNUL (LINE)
*
*
* Purpose:
*     Find the length of a null terminated string
*
*
* Description:
*     This function returns the number of characters in a string.
*     The end of the string is marked by a null character.  The null
*     character must be followed by blanks (or be the last character
*     in the string) for it to be considered a delimiter.  Specifically
*     if the string contains a sequence of null characters, only the
*     last one is eligible for consideration as a string terminator.
*     If no null character appears in the string, the number of
*     characters string is set to the length of the character string.
*
*
* Parameters:
* I <-  LENNUL - The returned function value is the number of
*                characters in the character string up to the
*                delimiting null character
*
* C ->  LINE   - Input character string
*
*
* Routines required:
*     INDEXR - Find the last occurrence of a string in a string
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 00:00:33 $
*
*
*-----------------------------------------------------------------------

      INTEGER FUNCTION LENNUL (LINE)


      INTEGER I,LENL
      INTEGER INDEXR

      CHARACTER*(*) LINE
      CHARACTER*1 NUL


      LENL=LEN(LINE)

* Find the position of a terminating null character
      NUL=CHAR(0)
      I=INDEXR(LINE,NUL)

* No null found
      IF (I.EQ.0) THEN
        LENNUL=LENL

* Null found, make sure blanks follow
      ELSE IF (I.LT.LENL) THEN
        IF (LINE(I+1:).EQ.' ') THEN
          LENNUL=I-1
        ELSE
          LENNUL=LENL
        END IF

* Null at end of string
      ELSE
        LENNUL=LENL-1

      END IF


      RETURN

      END
