*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     INTEGER FUNCTION KEYUPC (INSTR, KEYTAB, NOKEY)
*
*
* Purpose:
*     Match keyword strings (case insensitive)
*
*
* Description:
*     This subroutine searches a table for a match to a character
*     string.  The table of keywords is searched for the first match.
*     White space (blanks, tabs or null characters) at the beginning
*     or end of the input string, or at the end of the keyword string
*     is not significant.  The match is done against an uppercase
*     version of the input string.
*
*     This routine invokes the function KEYMAT using an uppercase
*     version of the input string (with leading white space removed).
*
*
* Parameters:
* I <-  KEYUPC - Output index of the matched keyword.  KEYUPC is set to
*                0 if no match was found.
*                   0 - No match
*                   1 - Match to the first keyword
*                   2 - Match to the second keyword
*                       ...
*
* C ->  INSTR  - Input character string.  There is no limit on the
*                length of INSTR if KEYTAB has elements which have
*                length less than 513 characters.  Otherwise, the
*                number of characters in INSTR, not including leading
*                or trailing white space, can be at most 513
*                characters.
* C ->  KEYTAB - Character array containing the candidate keywords.
*                An optional asterisk ('*') is used to indicate the
*                minimum number of characters needed for a match.
*                A second asterisk can be used to indicate that
*                characters in the input string after this point need
*                not match.  The keywords should be in uppercase and
*                should not contain leading white space.
*                Example: Keyword table entry 'ABC*DE*F'.
*                  - Input strings 'ABC', 'ABCD', ' ABC', 'abC',
*                    'ABCDE', and 'ABCDEx' match this entry.
*                  - Input strings 'AB' and 'ABCX' do not match this
*                    entry.
* I ->  NOKEY  - Number of keywords in the keyword array
*
*
* Routines required:
*     KEYMAT - Match keyword strings (case sensitive)
*     LOCNBL - Find the first non-whitespace character in a string
*     UPCASE - Convert a string to uppercase (trim and obey quotes)
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.4 $  $Date: 1993/01/25 00:00:34 $
*
*
*-----------------------------------------------------------------------

      INTEGER FUNCTION KEYUPC (INSTR, KEYTAB, NOKEY)


      INTEGER MAXNCK
      PARAMETER (MAXNCK=512)

      INTEGER NOKEY
      INTEGER IS,IF,L
      INTEGER LOCNBL,KEYMAT

      CHARACTER*(*) KEYTAB(NOKEY),INSTR
      CHARACTER*(MAXNCK) TEMPST


* We never need to pass a string longer than the length of the keyword
* string plus one.  Recall that a second asterisk allows for matches to
* strings longer than the keywords.
      IS=LOCNBL(INSTR)
      IF=MIN(IS+LEN(KEYTAB(1)),LEN(INSTR))

* Force UPCASE to complain "string truncated" if INSTR is too long
      L=MIN(IF-IS+1,MAXNCK)
      CALL UPCASE(INSTR(IS:IF),TEMPST(1:L))
      KEYUPC=KEYMAT(TEMPST(1:L),KEYTAB,NOKEY)


      RETURN

      END
