*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     INTEGER FUNCTION ICEIL (K, L)
*
*
* Purpose:
*     Calculate the ceiling function of a ratio of integers
*
*
* Description:
*     This function calculate the ceiling function of K/L. It returns
*     the smallest integer that is greater than or equal to the
*     quotient.
*
*
* Parameters:
* I <-  ICEIL - Resultant value
*
* I ->  K     - Numerator integer value
* I ->  L     - Denominator integer value
*
*
* Routines required:
*     None
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/24 20:52:18 $
*
*
*-----------------------------------------------------------------------

      INTEGER FUNCTION ICEIL (K, L)


      INTEGER K,L
      INTEGER LA,KA


* Find the signs of the input
* Find KA and LA, such that KA/LA=K/L and  LA is positive
      IF (L.GT.0) THEN
        LA=L
        KA=K
      ELSE
        LA=-L
        KA=-K
      END IF

* Integer division forms the correct result for negative numbers
      IF (KA.LE.0) THEN
        ICEIL=KA/LA
      ELSE
        ICEIL=(KA-1)/LA +1
       END IF


      RETURN

      END
