*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     REAL FUNCTION EVCINT (X, X1, X2, Y1, Y2, D1, D2)
*
*
* Purpose:
*     Evaluate a cubic, given values and derivatives
*
*
* Description:
*     This function calculates the value of an interpolating cubic for
*     a given abscissa value.  The cubic is specified in terms of its
*     values and derivatives at two points.
*
*
* Parameters:
* R <-  EVCINT - Output value
*
* R ->  X      - Abscissa value at which the cubic is to be evalutated
* R ->  X1     - Abscissa value at the first point
* R ->  X2     - Abscissa value at the second point
* R ->  Y1     - Value at the first point
* R ->  Y2     - Value at the second point
* R ->  D1     - Derivative at the first point
* R ->  D2     - Derivative at the second point
*
*
* Routines required:
*     HALT   - Print an error message, stop with error status set
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/24 20:44:48 $
*
*
*-----------------------------------------------------------------------

      REAL FUNCTION EVCINT (X, X1, X2, Y1, Y2, D1, D2)


      REAL X,X1,X2,Y1,Y2,D1,D2
      REAL DX,S,DD1,DD2,XI


* Check for distinct X values
      DX=X2-X1
      IF (DX.EQ.0.0)
     -  CALL HALT('EVCINT - Abscissa values not distinct')


      S=(Y2-Y1)/DX
      DD1=(D1-S)/DX
      DD2=(D2-S)/DX

* Evaluate the cubic
      XI=X-X1
      EVCINT=Y1 + XI*(D1 + XI*(-(DD1+DD2+DD1) + XI*((DD1+DD2)/DX)))


      RETURN

      END
