*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE LGCOEF (AD, X, N)
*
*
* Purpose:
*     Generate Lagrange interpolation coefficients
*
*
* Description:
*     This subroutine calculates a set  of Lagrange interpolation
*     coefficients given a set of abscissa values.  Function VLGINT
*     can be used to calculate the interpolated function values.  The
*     calculated coefficients are calculated as
*
*               N       1/2
*       a(k) = PROD  --------- .
*              i=1   x(k)-x(i)
*            (omit k)
*
*     The factor 1/2 in the numerator is used to prevent the product
*     from getting too small for x(i) less than unity.
*
*
* Parameters:
* D <-  AD     - Double precision array of coefficients
* D ->  X      - Double precision array of abscissa values (distinct)
* I ->  N      - Number of elements in each of the arrays AD and X
*
*
* Routines required:
*     HALT   - Print an error message, stop with error status set
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 05:21:01 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE LGCOEF (AD, X, N)


      INTEGER N
      INTEGER LD,K,L,I

      DOUBLE PRECISION AD(N),X(N)
      DOUBLE PRECISION DK,XK


* Calculate the interpolation coefficients
*   The order of the calculations is scrambled to try to preserve
*   dynamic range.
      LD=N/10+1
      DO 300 K=1,N
        DK=1D0
        XK=X(K)
        DO 200 L=1,LD
          DO 100 I=L,N,LD
            IF (I.NE.K) DK=2D0*DK*(XK-X(I))
  100     CONTINUE
  200   CONTINUE
        IF (DK.EQ.0D0)
     -    CALL HALT('LGCOEF - Abscissa values not distinct')
        AD(K)=1D0/DK
  300 CONTINUE


      RETURN

      END
