*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE FIRDSG (H, NTAP, ITYPE, GRIDD, IBAND, NBANDS,
*                        FREQ, VAL, WEIGHT, VLIML, VLIMU,
*                        DEVS, IER)
*
*
* Purpose:
*     Design a linear phase FIR filter
*
*
* Description:
*     This routine designs multiple band bandpass filters,
*     differentiators, or Hilbert transform filters using the Remez
*     exchange algorithm.
*     References:
*       J.H. McClellan, T.W. Parks and L.R. Rabiner, "A computer
*       program for designing optimum FIR linear phase digital
*       filters", IEEE Trans. Audio and Electroacoustics, vol. AU-21,
*       pp. 506-526, December 1973.
*       F. Grenez, "Design of linear or minimum-phase FIR filters by
*       constrained Chebyshev approximation", Signal Processing,
*       vol. 5, pp. 325-332, July 1983.
*
*
* Parameters:
* R <-  H      - Array of resultant filter coefficients
* I ->  NTAP   - Number of filter coefficients desired (maximum 256)
* I ->  ITYPE  - Filter type.
*                1 - Multiple passband/stopband filter
*                2 - Multiple passband/stopband filter
*                    (sin(X)/X compensation)
*                3 - Differentiator
*                4 - Hilbert transform filter
* R ->  GRIDD  - Grid density.  The number of points in the frequency
*                grid used to determine the extrema of the
*                approximating function is the product of GRIDD and
*                the number of degrees of freedom for the filter
*                coefficients
*                (approximately NTAP/2).
*                 0 - If GRIDD is zero, the grid density is chosen to
*                     be near the largest possible (given the internal
*                     array space available) up to a maximum of 16
*                -1 - If GRIDD is -1, the grid density is chosen to be
*                     near the largest possible given the internal
*                     array space available
* I ->  IBAND  - Frequency band specification index.  The array FREQ is
*                used to specify the frequency bands.
*                 Band    Lower Band Edge          Upper Band Edge
*                  1     FREQ(1)                  FREQ(IBAND(1))
*                  2     FREQ(IBAND(1)+1)         FREQ(IBAND(2))
*                 ...        ...                    ...
*                NBANDS  FREQ(IBAND(NBANDS-1)+1)  FREQ(IBAND(NBANDS))
*                VAL(i), WEIGHT(i), VLIML(i), and VLIMU(i) specify the
*                desired value, weight, lower limit, and upper limit
*                at frequency FREQ(i).  These values are interpolated
*                using a piecewise monotonic cubic function between
*                frequencies within a band.
* I ->  NBANDS - Number of bands specified
* R ->  FREQ   - Array of normalized frequencies.  These values must be
*                in increasing order, 0 <= FREQ(i) < FREQ(i+1) <= 1/2.
* R ->  VAL    - Array of desired amplitude values (desired slopes for
*                differentiators)
* R ->  WEIGHT - Array of desired weightings.  For differentiators,
*                the given weighting applies to the slope. WEIGHT(i)
*                must be positive.
* R ->  VLIML  - Array of lower constraints. VLIML(i) must be less than
*                or equal to VAL(i).
* R ->  VLIMU  - Array of upper constraints.  VLIMU(i) must be greater
*                than or equal to VAL(i).
* R <-  DEVS   - Resultant deviation from the desired specifications.
*                This value is unweighted.  The deviation at a given
*                frequency is obtained by dividing by the weight at
*                that frequency.
* I <-  IER    - Error parameter coded as follows.
*                0  - No error
*                1  - Remez algorithm failed to converge, the deviation
*                     is not monotonically increasing
*                2  - Remez algorithm failed to converge, too many
*                     iterations
*                For these cases, this routine returns coefficient
*                values.  For all other errors, an error message is
*                printed and execution is halted.
*
*
* Routines required:
*     FIRCHG - Find FIR filter specifications on a frequency grid
*     FIRREM - Design an FIR filter: Remez exchange algorithm
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 05:17:31 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE FIRDSG (H, NTAP, ITYPE, GRIDD, IBAND, NBANDS,
     -                   FREQ, VAL, WEIGHT, VLIML, VLIMU,
     -                   DEVS, IER)


      INTEGER NGMAX,NHMAX
      PARAMETER (NGMAX=1000,NHMAX=256)

      INTEGER NTAP,ITYPE,NBANDS,IBAND(NBANDS),IER
      INTEGER ICASE,NGRID,I

      REAL H(0:NTAP-1),GRIDD,FREQ(*),VAL(*),WEIGHT(*),
     -     VLIML(*),VLIMU(*),DEVS
      REAL FGRID(NGMAX),XGRID(NGMAX),DES(NGMAX),WT(NGMAX),
     -     DLIML(NGMAX),DLIMU(NGMAX)

      DOUBLE PRECISION HD(0:NHMAX-1)


* Convert to a specification on a dense grid of frequencies
      CALL FIRCHG(NTAP,ITYPE,GRIDD,IBAND,NBANDS,FREQ,VAL,WEIGHT,
     -            VLIML,VLIMU,NGMAX,ICASE,NGRID,FGRID,XGRID,
     -            DES,WT,DLIML,DLIMU)

* Find the coefficients of the approximation
      CALL FIRREM(NGRID,XGRID,DES,WT,DLIML,DLIMU,
     -            ICASE,HD,NTAP,DEVS,IER)

* Copy the impulse response to the output array
      DO 120 I=0,NTAP-1
        H(I)=HD(I)
 120  CONTINUE


      RETURN

      END
