*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE DRPOLY (X, NX, ZR, ZI, NROOT)
*
*
* Purpose:
*     Find the roots of a polynomial with real coefficients
*
*
* Description:
*     This routine finds the roots of the polynomial specified by the
*     input coefficients.
*
*
* Parameters:
* D ->  X      - Array of input double precision polynomial
*                coefficients.  The first element of X, X(1) is the
*                constant coefficient.
* I ->  NX     - Number of input coefficients (maximum 128)
* D <-  ZR     - Output double precision array of the real parts of the
*                roots (NROOT values)
* D <-  ZI     - Output double precision array of the imaginary parts
*                of the roots (NROOT values)
* I <-  NROOT  - Number of roots found.  This value is at most NX-1. If
*                trailing coefficients (corresponding to the highest
*                powers) are zero, NROOT will be at most NX-1.  The
*                missing roots can be considered to be at infinity.
*
*
* Routines required:
*     DREV   - Reverse the order of a DOUBLE PRECISION array
*     HALT   - Print an error message, stop with error status set
*     RPOLY  - Find the roots of a polynomial (CACM-TOMS)
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.4 $  $Date: 1993/01/25 05:45:34 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE DRPOLY (X, NX, ZR, ZI, NROOT)


      INTEGER NXMAX
      PARAMETER (NXMAX=128)

      INTEGER NX,NROOT
      INTEGER I,NXR

      LOGICAL FAIL

      DOUBLE PRECISION X(NX),ZR(*),ZI(*)
      DOUBLE PRECISION XR(NXMAX)


* Find the last non-zero coefficient
      DO 120 I=NX,1,-1
        IF (X(I).NE.0D0) GO TO 160
 120  CONTINUE
 160  NXR=I
      NROOT=I-1


* Find the roots of the polynomial
      IF (NXR.GT.101) CALL HALT('DRPOLY - Too many coefficients')
      IF (NROOT.GT.0) THEN
        CALL DREV(X,XR,NXR)
        CALL RPOLY(XR,NROOT,ZR,ZI,FAIL)
        IF (FAIL) CALL HALT('DRPOLY - Root finder failed')
      END IF


      RETURN

      END
