*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE DLNEQN (A, NDIM, N, C, B)
*
*
* Purpose:
*     Solve a general set of linear equations
*
*
* Description:
*     This routine solves a set of linear equations for a general
*     matrix.  For a given matrix A and given vector c, this routine
*     solves for the vector b,
*
*       A b = c .
*
*
* Parameters:
* D ->  A      - Matrix of double precision coefficients
* I ->  NDIM   - Leading dimension of matrix A
* I ->  N      - Number of equations (maximum 128)
* D ->  C      - Double precision right hand side vector (N elements)
* D <-  B      - Output double precision result (N elements)
*
*
* Routines required:
*     DGEFA  - Factor a general matrix (Linpack,dp)
*     DGESL  - Solve a set of equations (Linpack,dp)
*     HALT   - Print an error message, stop with error status set
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.4 $  $Date: 1993/01/25 05:45:25 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE DLNEQN (A, NDIM, N, C, B)


      INTEGER NMAX
      PARAMETER (NMAX=128)

      INTEGER NDIM,N
      INTEGER I,J,INFO
      INTEGER IPVT(NMAX)

      DOUBLE PRECISION A(NDIM,N),C(N),B(N)
      DOUBLE PRECISION AP(NMAX,NMAX)


      IF (N.GT.NMAX) CALL HALT('DLNEQN - Too many equations')

* Copy the coefficient matrix
      DO 120 J=1,N
        DO 100 I=1,N
          AP(I,J)=A(I,J)
 100    CONTINUE
        B(J)=C(J)
 120  CONTINUE

* Factor the coefficient matrix
      CALL DGEFA(AP,NDIM,N,IPVT,INFO)
      IF (INFO.NE.0)
     -  CALL HALT('DLNEQN - Equations numerically singular')

* Solve the equations
      CALL DGESL(AP,NMAX,N,IPVT,B,0)


      RETURN

      END
