*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE CHSPEC (ITYPE, NGRID, FGRID,
*                        DES, DEST, WT, WTT,
*                        DLIML, DLIMLT, DLIMU, DLIMUT)
*
*
* Purpose:
*     Modify the specifications for an FIR filter
*
*
* Description:
*     This routine modifies the specifications of certain types of
*     filters.  The specifications are given in terms of a desired
*     value, weight and constaint values at given frequencies.  For
*     receiving filters, the specifications are modified to include an
*     x/sin(x) factor. For differentiators, the specifications are
*     changed from a desired slope to a desired value.
*
*
* Parameters:
* I ->  ITYPE  - Filter type.
*                1 - Multiple passband/stopband filter
*                2 - Multiple passband/stopband filter
*                    (sin(X)/X compensation)
*                3 - Differentiator
*                4 - Hilbert transform filter
* I ->  NGRID  - Number of elements in each of FGRID, DES, WT,
*                DLIML, and DLIMU
* R ->  FGRID  - Normalized frequency values on the grid in the range
*                [0,1/2]. For Differentiators, FGRID(i) cannot be zero.
* R  -> DES    - Desired values on the grid
* R <-  DEST   - Modified desired values on the grid
* R ->  WT     - Weight values on the grid
* R <-  WTT    - Modified weight values on the grid
* R ->  DLIML  - Lower constraint values on the grid
* R <-  DLIMLT - Modified lower constraint values on the grid
* R ->  DLIMU  - Upper constraint values on the grid
* R <-  DLIMUT - Modified upper constraint values on the grid
*
*
* Routines required:
*     None
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 05:05:41 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE CHSPEC (ITYPE, NGRID, FGRID,
     -                   DES, DEST, WT, WTT,
     -                   DLIML, DLIMLT, DLIMU, DLIMUT)


      INTEGER BPF,REC,DIF,HIL
      REAL PI
      PARAMETER (BPF=1,REC=2,DIF=3,HIL=4)
      PARAMETER (PI=3.141 592 654)

      INTEGER ITYPE,NGRID
      INTEGER I

      REAL FGRID(NGRID),DES(NGRID),DEST(NGRID),
     -     WT(NGRID),WTT(NGRID),DLIML(NGRID),DLIMLT(NGRID),
     -     DLIMU(NGRID),DLIMUT(NGRID)
      REAL FR,CH


* For differentiators, change the desired slope to a desired value
      IF (ITYPE.EQ.DIF) THEN
        DO 120 I=1,NGRID
          FR=FGRID(I)
          DEST(I)=FR*DES(I)
          WTT(I)=WT(I)/FR
          DLIMLT(I)=FR*DLIML(I)
          DLIMUT(I)=FR*DLIMU(I)
 120    CONTINUE

* For receive filters, modify the desired value by x/sin(x)
      ELSE IF (ITYPE.EQ.REC) THEN
        DO 140 I=1,NGRID
          FR=FGRID(I)
          IF (FR.NE.0.0) THEN
            CH=(PI*FR)/SIN(PI*FR)
            DEST(I)=CH*DES(I)
            DLIMLT(I)=CH*DLIML(I)
            DLIMUT(I)=CH*DLIMU(I)
          ELSE
            DEST(I)=DES(I)
            DLIMLT(I)=DLIML(I)
            DLIMUT(I)=DLIMU(I)
          END IF
          WTT(I)=WT(I)
 140    CONTINUE

* Other types of filters, no change
      ELSE
        DO 160 I=1,NGRID
          DEST(I)=DES(I)
          WTT(I)=WT(I)
          DLIMLT(I)=DLIML(I)
          DLIMUT(I)=DLIMU(I)
 160    CONTINUE

      END IF


      RETURN

      END
