/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  double INfiltMSE (const double rxx[], const double h[], const double p[],
		    int N)

Purpose:
  Calculate the mean-square filtering error

Description:
  This function calculates the mean-square error for a linear estimation
  problem.  Given a random stationary input signal x(k), characterized by an
  autocorrelation function, R(i) = E[x(k+i) x(i)], this routine finds the
  mean-square error for y(k), a linearly filtered version of x(k),

            N2
    y(k) = SUM h(i) x(k-i) .
           i=N1

  The filter lags vary from N1 to N2.  The error is e(k)=d(k)-y(k), where d(k)
  is the desired signal. The mean-square filtering error is E[e(k)^2] or in
  vector-matrix notation

    E = rxx(0) - 2 h' p + h' R h ,

  where the cross-correlation vector is p(i) = E[d(k) x(k-i)], and the auto-
  correlation matrix is R(i,j) = E[x(k-i) x(k-j)].  The elements of the auto-
  correlation matrix R, can be expressed as R(i,j) = rxx(|i-j|).

  Linear prediction can be cast into the above form, if we let N1=1.  Also
  for linear prediction, usually d(k)=x(k), giving p(k)=rxx(|k|).

Parameters:
  <-  double INfiltMSE
      Resulting mean-square error
   -> const double rxx[]
      N element vector of autocorrelation values.  Element rxx[i] is the
      autocorrelation at lag i.
   -> const double h[]
      N element vector of filter coefficients.  Coefficient h[i] is the filter
      coefficient corresponding to lag N1+i.
   -> const double p[]
      N element vector of autocorrelation values.  Element p[i] is the cross-
      correlation at lag N1+i.
   -> int N
      Number of elements in each of the vectors rxx, h and p.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.7 $  $Date: 1996/02/14 23:20:47 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: INfiltMSE.c 1.7 1996/02/14 FilterDesign-V1R7a $";

#include "DFiltInt.h"

double
INfiltMSE (rxx, h, p, N)

     const double rxx[];
     const double h[];
     const double p[];
     int N;

{
  double er, sumL, sumR;
  int i, j;

/* Calculate the resulting mean-square error */
/*
   E = rxx(0) - h' (2 p - R h)
*/
  er = 0.0;
  for (i = 0; i < N; ++i) {
    sumL = 0.0;
    sumR = 0.0;
    for (j = 0; j <= i; ++j)
      sumL = sumL + rxx[i-j] * h[j];
    for (j = N - 1; j > i; --j)
      sumR = sumR + rxx[j-i] * h[j];
    er = er + h[i] * (2.0 * p[i] - (sumL + sumR));
  }
  return (rxx[0] - er);
}
