/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int STdec1float (const char String[], float *Fval)

Purpose:
  Decode a float value

Description:
  This routine decodes a string containing a numeric value.  The decoded datum
  is stored as a float value.  If a decoding error is detected, a warning
  message is printed and error status is set.  A warning messages is printed
  if extra data follows the requested value (this data is ignored).

Parameters:
  <-  int STdec1float
      Error status, 0 for no error, 1 for error
   -> const char String[]
      Input string
  <-  float *Fval
      Returned value.  This value is not changed if an error status is
      returned.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.9 $  $Date: 1996/05/31 19:08:32 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdec1float.c 1.9 1996/05/31 AFsp-V2R2 $";

#include <libtsp.h>
#include <libtsp/nucleus.h>

int
STdec1float (String, Fval)

     const char String[];
     float *Fval;

{
  return (STdec1val (String, 'F', (void *) Fval));
}
