/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  long int FLfileSize (FILE *fp)

Purpose:
  Find the size of a file

Description:
  This routine finds the size of a binary file.  The size of the file is
  determined by positioning to end-of-file and returning the end-of-file
  position.  On exit, the file position is restored to the original position.

Parameters:
  <-  long int FLfileSize
      File size in bytes
   -> FILE *fp
      File pointer associated with the file

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.16 $  $Date: 1995/05/20 10:11:47 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: FLfileSize.c 1.16 1995/05/20 AFsp-V2R2 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>

#ifndef SEEK_SET	/* normally defined in stdio.h */
#  include <unistd.h>
#endif

long int
FLfileSize (fp)

     FILE *fp;

{
  long int pos;
  long int endpos;

/*
   The ANSI C standard does not guarantee that this method of determining
   the file size will work on all systems.  It works on Unix systems and
   probably a lot of other systems.  The alternative is to use stat, but that
   is probably even less portable.
   */
  pos = ftell (fp);
  if (pos == EOF)
    UTerror ("FLfileSize: Cannot determine file position");

  if (fseek (fp, 0L, SEEK_END) != 0)
    UTerror ("FLfileSize: File positioning error");

  endpos = ftell (fp);
  fseek (fp, pos, SEEK_SET);

  return endpos;
}
