/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void AFupdAUhead (const AFILE *AFp)

Purpose:
  Update header information in an AFsp (Sun) audio file

Description:
  This routine updates the data length field of an AFsp (Sun) format audio
  file.  The file is assumed to have been opened with routine AFopenWrite.

Parameters:
   -> const AFILE *AFp
      Audio file pointer for an audio file opened by AFopenWrite

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.23 $  $Date: 1996/05/06 18:12:29 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFupdAUhead.c 1.23 1996/05/06 AFsp-V2R2 $";

#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/AFpar.h>
#include <libtsp/AUpar.h>

#define WHEAD_V(fp,offs,value,swap) \
			AFwriteHead (fp, (long int) (offs), \
				     (void *) &(value), \
				     sizeof (value), 1, swap)

void
AFupdAUhead (AFp)

     const AFILE *AFp;

{
  uint4_t Ldata;

/* Checks */
  if (AFp->Op != FO_WO)
    UThalt ("AFupdAUhead: File not opened for write");
  if (AFp->Ftype != FT_AFSP && AFp->Ftype != FT_SUN)
    UThalt ("AFupdAUhead: Not an AFsp (Sun) audio file");

/* Write out the updated data length */
  Ldata = (uint4_t) (AFp->End - AFp->Start);
  WHEAD_V (AFp->fp, 8L, Ldata, DS_EB);

  return;
}
