/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void AFprintAFh (AFILE *AFsp, const char Fname[], const char Datetime[],
                   double Sfreq, FILE *fpout)

Purpose:
  Check and print header information for an audio file

Description:
  This routine checks and then optionally prints header information for an
  audio file.

Parameters:
   -> AFILE *AFp
      Audio file pointer for the audio file
   -> const char Fname[]
      File name
   -> const char Datetime[]
      Date and time string from the header.  If Datetime is NULL or the date
      and time string is empty, the file modification date/time is used.  The
      date/time string is printed only for files which have been opened for
      reading.
   -> double Sfreq
      Sampling frequency from the file header
   -> FILE *fpout
      File pointer for printing the audio file identification information.  If
      fpout is NULL, no information is printed.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.15 $  $Date: 1996/08/14 18:00:44 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFprintAFh.c 1.15 1996/08/14 AFsp-V2R2 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/AFpar.h>

static const int Lenb[NFD] = {
  0,
  FDL_MULAW8,
  FDL_ALAW8,
  FDL_UINT8,
  FDL_INT8,
  FDL_INT16,
  FDL_FLOAT32,
  FDL_TEXT
};
static const char *Fd[NFD] = {
  NULL,
  "8-bit mu-law",
  "8-bit A-law",
  "offset-binary 8-bit integer",
  "8-bit integer",
  "16-bit integer",
  "32-bit float",
  "text data"
};
static const char *Ft[NFT] = {
  NULL,
  "Audio file",		/* Headerless or non-standard audio file */
  "AFsp audio file",
  "Sun audio file",
  "RIFF WAVE file",
  "AIFF-C audio file",
  "NIST SPHERE audio file",
  "ESPS audio file",
  "IRCAM soundfile",
  "SPPACK file",
  "INRS-Telecom audio file",
  "AIFF audio file",
  "Text audio file"
};

void
AFprintAFh (AFp, Fname, Datetime, Sfreq, fpout)

     AFILE *AFp;
     const char Fname[];
     const char Datetime[];
     double Sfreq;
     FILE *fpout;

{
  const char *dt;
  const char *ft;
  char FullName[FILENAME_MAX+1];

/* AFp checks */
  if (AFp->Format <= 0 || AFp->Format >= NFD)
    UThalt ("AFprintAFh: Invalid data format code");
  if (AFp->Ftype <= 0 || AFp->Ftype >= NFT)
    UThalt ("AFprintAFH: Invalid file type");

/* Print the header information */
  if (fpout != NULL) {

    /* Type of file and name */
    ft = Ft[AFp->Ftype];
    if (AFp->Ftype == FT_NH && AFp->Start == 0)
      ft = "Headerless audio file";
    FLfullName (Fname, FullName);
    fprintf (fpout, " %s: %s\n", ft, FullName);

    /* Number of samples and date (only for read) */
    if (AFp->Op == FO_RO) {
      if (Datetime == NULL || Datetime[0] == '\0')
	dt = FLfileDate (AFp->fp, 3);
      else
	dt = Datetime;
      fprintf (fpout, "   Number of samples : %ld  %.30s\n", AFp->Nsamp, dt);
    }

    /* Sampling frequency */
    fprintf (fpout, "   Sampling frequency: %.6g Hz\n", Sfreq);

    /* Number of channels and data format */
    fprintf (fpout, "   Number of channels: %ld (%s)\n", AFp->Nchan,
	     Fd[AFp->Format]);
  }
  return;
}
