/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  char *AFreadHinfo (AFILE *AFp, int *Ninfo)

Purpose:
  Read an AFsp audio file header information string

Description:
  This routine reads the information string from an AFsp audio file header.
  The AFsp audio file header information string consists of a sequence of null
  terminated strings corresponding to the header records.  If the last record
  is not null terminated, a null is added.  The string is Ninfo characters
  long, including this terminating null.  If the audio file is not an AFsp
  file, a pointer to an empty string is returned.

Parameters:
  <-  char *AFreadHinfo
      Pointer to the header information string.  This is a pointer to a
      dynamically allocated storage area; each call to this routine reallocates
      this storage area.
   -> AFILE *AFp
      File pointer for the audio file
  <-  int *Ninfo
      Number of characters in the header information string

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.23 $  $Date: 1996/05/31 12:51:27 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: AFreadHinfo.c 1.23 1996/05/31 AFsp-V2R2 $";

#include <stdio.h>
#include <string.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/AFpar.h>
#include <libtsp/AUpar.h>

#define RHEAD_SN(fp,offs,string,N) \
			AFreadHead (fp, (long int) (offs), (void *) string, \
					    1, N, DS_NATIVE)

char *
AFreadHinfo (AFp, Ninfo)

     AFILE *AFp;
     int *Ninfo;

{
  int nc;
  static char Empty[] = "";
  static char *Hinfo = NULL;

  if (AFp->Op != FO_RO && AFp->Op != FO_WO)
    UThalt ("AFreadHinfo: File not open");

/* Check the file type */
  if (AFp->Ftype != FT_AFSP) {
    *Ninfo = 0;
    return Empty;
  }

/* Read the header information string into an allocated area */
  if (AFp->Start - AFsp_LHMIN <= AFsp_MAXINFO)
    nc = (int) (AFp->Start - AFsp_LHMIN);
  else {
    nc = AFsp_MAXINFO;
    UTwarn ("AFreadHinfo - Header information too long, truncated");
  }
  UTfree ((void *) Hinfo);
  Hinfo = (char *) UTmalloc (nc+1);
  RHEAD_SN (AFp->fp, AFsp_LHMIN, Hinfo, nc);

/* Add a trailing null if necessary */
  if (Hinfo[nc-1] != '\0') {
    Hinfo[nc] = '\0';
    ++nc;
  }

/* Return a pointer to the header information */
  *Ninfo = nc;
  return Hinfo;
}
