/*------------- Telecommunications & Signal Processing Lab -------------
                           McGill University

Routine:
  void LPoptions (int argc, const char *argv[], int *Fstats
		  const char **Hinfo, const char *Fname[4])

Purpose:
  Decode options for LPanal and LPsyn

Description:
  This routine decodes options for LPanal and LPsyn.

Parameters:
   -> int argc
      Number of command line arguments
   -> const char *argv[]
      Array of pointers to argument strings
  <-  int *Fstats
      Frame statistics flag
  <-  const char **Hinfo
      Header information string, default NULL
  <-  const char *Fname[4]
      File names: input parameter file,
                  input audio file,
                  LPC file,
                  output audio file

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.7 $  $Date: 1996/06/01 02:38:15 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: LPoptions.c 1.7 1996/06/01 AFsp-V2R2 $";

#include <stdlib.h>		/* prototype for exit */
#include <stdio.h>
#include <libtsp.h>
#include <libtsp/AFpar.h>

#ifndef LPSYN
#  include "LPanal.h"
#else
#  include "LPsyn.h"
#endif

#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS	0	/* Normally in stdlib.h */
#endif

#define NELEM(array)	((sizeof array) / (sizeof array[0]))

/* Option tables and usage message */
#define LOPT	(NELEM (OptTable) / 2)
static const char *nullTable[] = { NULL };
static const char *OptTable[] = {
  "-p#", "--par*ameter_file=",
  "-c#", "--lpc*_file=",
  "-s",  "--s*tatistics",
  "-I#", "--i*nfo=",
  "-h",  "--h*elp",
  "-v",  "--v*ersion",
  "--",
  NULL
};
static const char Usage[] = "\
Usage: %s [options] AFileI [AFileO]\n\
Options:\n\
  -p Pfile, --parameter_file=Pfile,\n\
                              Parameter file.\n\
  -c LPFile, --lpc_file=LPFile\n\
                              LPC predictor coefficient file.\n\
  -s, --statistics            Print frame-by-frame statistics.\n\
  -I INFO, --info=INFO        Header information string.\n\
  -h, --help                  Print a list of options and exit.\n\
  -v, --version               Print the version number and exit.";

void
LPoptions (argc, argv, Fstats, Hinfo, Fname)

     int argc;
     const char *argv[];
     int *Fstats;
     const char **Hinfo;
     const char *Fname[4];

{
  int Index;
  const char *OptArg;
  const char **optt;
  int Fstatsx;

  int nF, n, nn;

/* Defaults */
  Fstatsx = 0;
  *Hinfo = NULL;
  Fname[2] = NULL;
  Fname[3] = NULL;

/* Initialization */
  UTsetProg (PROGRAM);
  nF = 0;

/* Decode options */
  Index = 1;
  optt = OptTable;
  while (Index < argc) {
    n = UTgetOption (&Index, argc, argv, optt, &OptArg);
    nn = ((n + 3) / 2) - 1;	/* n = -2 ==> nn = -1 */
    switch (nn) {
    case 0:
      /* Filename argument */
      ++nF;
      if (nF == 1)
	Fname[1] = OptArg;
      else if (nF == 2)
	Fname[3] = OptArg;
      else
	UThalt ("%s: Too many filenames specified", PROGRAM);
      break;
    case 1:
      /* Parameter file */
      Fname[0] = OptArg;
      break;
    case 2:
      /* LPC file */
      Fname[2] = OptArg;
      break;
    case 3:
      /* Frame statistics */
      Fstatsx = 1;
      break;
    case 4:
      /* Header information string */
      *Hinfo = OptArg;
      break;
    case LOPT-2:
      /* Help */
      UTwarn (Usage, PROGRAM);
      exit (EXIT_SUCCESS);
      break;
    case LOPT-1:
      /* Version */
      printf ("%s: %s\n", PROGRAM, VERSION);
      exit (EXIT_SUCCESS);
      break;
    case LOPT:
      /* Stop interpreting options */
      optt = nullTable;
      break;
    default:
      /* Option error */
      UThalt (Usage, PROGRAM);
      break;
    }
  }

/* Checks */
  if (nF < 1)
    UThalt ("%s: No input audio file", PROGRAM);
  if (Fname[0] == NULL)
    UThalt ("%s: No parameter file", PROGRAM);
  if (Fname[2] == NULL)
    UThalt ("%s: No LPC coefficient file", PROGRAM);

/* Return value */
  *Fstats = Fstatsx;

  return;
}
