/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  CopyAudio.h

Description:
  Declarations for CopyAudio

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.36 $  $Date: 1996/10/29 15:28:32 $

----------------------------------------------------------------------*/

#ifndef CopyAudio_h_
#define CopyAudio_h_

#define PROGRAM "CopyAudio"
#define VERSION	"v1r12b  1996/10/29"

#define MAXCHANI	20
#define MAXCHANO	12
#define MAXIFILE	10
#define MAXFILE		(MAXIFILE+1)

#include <libtsp.h>			/* typedef for AFILE */

#ifdef __cplusplus
extern "C" {
#endif

/* Prototypes */
void
CPcombSamp p_((AFILE *AFp[], long int Nchan[], int Nfiles, long int Lim[2],
	       float Chgain[MAXCHANO][MAXCHANI]));
void
CPcopySamp p_((AFILE *AFp[], long int Nchan[], int Nfiles, long int Lim[2],
	       double gain));
void
CPdecChan p_((const char String[], float Chgain[]));
void
CPoptions p_((int argc, const char *argv[], int *Fformat, float *SfreqO,
	      long int Lim[2], const char *NHparms[MAXIFILE],
	      const char **Hinfo, float Chgain[MAXCHANO][MAXCHANI],
	      long int *NchanO, const char *Fname[MAXFILE], int *Nfiles));

#ifdef __cplusplus
}
#endif

#endif /* CopyAudio_h_ */
