/*------------- Telecommunications & Signal Processing Lab --------------
                          McGill University
Routine:
  void CAprstat (const struct Stats_F *Stats)

Purpose:
  Print statistics for an audio file

Description:
  This routine prints statistics for audio file data.  The standard information
  printed includes the mean, standard deviation, maximum value and minimum
  value.  For data which is restricted to the range [-32768,+32767], and the
  minimum and maximum values take on integer values, two  additional counts
  (if nonzero) are reported.  These are the number of overloads and the number
  of anomalous transitions.

Parameters:
   -> const struct Stats_F *Stats
      Structure containing the file statistics

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.12 $  $Date: 1996/06/01 02:42:19 $

-----------------------------------------------------------------------*/

static char rcsid[] = "$Id: CAprstat.c 1.12 1996/06/01 AFsp-V2R2 $";

#include <math.h>		/* sqrt, modf */
#include <stdio.h>
#include "CompAudio.h"

#define MAXV(a, b)	(((a) > (b)) ? (a) : (b))

static const float Amax = 32767.;
static const float Amin = -32768.;

void
CAprstat (Stats)

     const struct Stats_F *Stats;

{
  double sd;
  double sm;
  double dint;
  long int N;

  N = Stats->N;
  if (N != 0) {
    sd = sqrt ((Stats->Sx2 - (Stats->Sx * Stats->Sx) / N)/ MAXV (N-1, 1) );
    sm = Stats->Sx / N;
    printf ("    Std Dev = %-11.5g Mean = %.5g\n", sd, sm);
    printf ("    Max     = %-11.5g Min  = %.5g\n", Stats->Vmax,
	    Stats->Vmin);

    if (Stats->Vmax <= Amax && Stats->Vmin >= Amin &&
	modf (Stats->Vmax, &dint) == 0.0 && modf (Stats->Vmin, &dint) == 0.0) {
      if (Stats->Novload > 0) {
	printf ("    No. Overloads = %ld", Stats->Novload);
	if (Stats->Nrun == 1)
	  printf (" (%ld run)\n", Stats->Nrun);
	else
	  printf (" (%ld runs)\n", Stats->Nrun);
      }
      if (Stats->Nanomal > 0)
	printf ("    No. Anomalous Transitions = %ld\n", Stats->Nanomal);
    }
  }
  else {
    printf ("    Std Dev = ***         Mean = ***\n");
    printf ("    Max     = ***         Min  = ***\n");
  }

  return;
}
