/* -*- c++ -*-
 *
 *  Generalized MIDI parser. Loosely based on BeOS classes.
 *  Copyright (c) by Thomas Hudson <thudson@cygnus.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdlib.h>
#include "MidiDefs.h"
typedef unsigned char uchar;

class MidiParser
{
public:
  const uchar SysEx;
  MidiParser();
  virtual uchar readByte() = 0; 
  void parseMidi();

protected:
  uchar _running_status;
  uchar _channel;
  uchar* _sysex_buf;
  int _data_count;
  bool _in_sysex;
  size_t _sysex_size;
  uchar _data_buf[3];

  bool isStatus(uchar byte) { return byte & 0x80; }
  bool isChannelMessage(uchar byte) { return byte < 0xf0; }
  bool isSystemExclusive(uchar byte) { return byte == 0xf0; }
  bool isSystemRealTime(uchar byte) { return (byte >= 0xf8) && (byte <= 0xff); }

};
