/*
 *	Audiality Plug-In Programming Interface - draft 0.1
 *
 *	Copyright (C) David Olofson, 1999
 *
 *	This code is released under the terms of the LGPL
 */

struct plugin_instance_t;

/*
 * Plug-in "class" description
 * A filled-in plugin_t should be passed to the engine
 * when registering. (This should probably handle sample
 * rates for control signals as well, as those should
 * actually *be* audio streams... That is, different
 * rates for different inputs and outputs, but within
 * certain restrictions.)
 */
struct plugin_t
{
	/*
	 * Restrictions to the number of frames processed
	 * by one process_XXX() call
	 */
	int frames_flags;	/* FF_POWER_OF_TWO and things like that */
	int frames_min;
	int frames_max;
	int frames_granularity;	/* buffer size granularity */
	/*
	 * Restrictions to the sample rate
	 */
	int rate_flags;		/* RF_POWER_OF_TWO,... */
	float rate_min;
	float rate_max;
	float rate_granularity;	/* have to think more about this... */
	/*
	 * Instance constructor and destructor...
	 */
	int (*create) (plugin_instance_t *plugin);
	int (*destroy) (plugin_instance_t *plugin);
	/*
	 * process_mix() mixes data into destination buffers,
	 * process_replace() overwrites.
	 *
	 * ! process_mix() _requires_ the plug-in to have
	 * ! output gain controls for the outputs!
	 *
	 * ? Should these be present in instances as well,
	 * ? so that plug-ins can change callbacks runtime?
	 * ? Probably not, for various reasons. And would
	 * ? anyone have any use for it in real life?
	 */
	int (*process_mix) (plugin_instance_t *plugin,
				float **inputs, float **outputs,
				int frames);
	int (*process_replace) (plugin_instance_t *plugin,
				float **inputs, float **outputs,
				int frames);
};

/*
 * The plug-in instance struct.
 * These should be created by the *host*, as it may
 * want to add extra info outside the struct.
 * (The use of the word "frame" instead of "sample"
 * is because I have ideas for other uses...)
 */
struct plugin_instance_t
{
	plugin_t *kind;
	float framerate;
	float inherent_delay;	/* Inherent means inherent to the
				 * processing algorithm, and is
				 * used for processing latency
				 * compensation.
				 * Value is in frames, and should
				 * reflect sub-sample resolution.
				 */
	int look_ahead;		/* Number of extra frames needed
				 * after the end of input buffers.
				 * Can be negative.
				 */
	int skip_behind;	/* Number of frames skipped
				 * at the start of input buffers.
				 * (That is, inputs[n]+=look_behind
				 * before process_XXX() is called.)
				 * Can be negative.
				 */
	void *user_data;
};

