# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;

/*
 * Copyright 1988 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens
 * 
 * written 16-17 Mar 1988 by claus gittinger
 *
 * atomizer for .bdf files
 *
 * modified 13-14 June 1988 by mike newton (newton@csvax.caltech.edu) to
 *   handle DEFAULT_CHAR, and blank lines better.  (see parse.y)
 */

#include "y.tab.h"
#include "defs.h"

int lineno = 1;
int stringMode = 0;

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
          return STARTFONT;
break;
case 2:
               return SIZE;
break;
case 3:
    return FONTBOUNDINGBOX;
break;
case 4:
    return STARTPROPERTIES;
break;
case 5:
       return FONTDESCENT;
break;
case 6:
        return FONTASCENT;
break;
case 7:
       return DEFAULTCHAR;
break;
case 8:
      return ENDPROPERTIES;
break;
case 9:
              return CHARS;
break;
case 10:
           return ENCODING;
break;
case 11:
             return SWIDTH;
break;
case 12:
             return DWIDTH;
break;
case 13:
                return BBX;
break;
case 14:
             return BITMAP;
break;
case 15:
            return ENDCHAR;
break;
case 16:
            return ENDFONT;
break;
case 17:
          {
			yylval.sval = malloc(strlen(yytext+5)+1);
			strcpy(yylval.sval, yytext+5);
			return FONT;
		    }
break;
case 18:
     {
			yylval.sval = malloc(strlen(yytext+10)+1);
			strcpy(yylval.sval, yytext+10);
			return COPYRIGHT;
		    }
break;
case 19:
     {
			yylval.sval = malloc(strlen(yytext+10)+1);
			strcpy(yylval.sval, yytext+10);
			return STARTCHAR;
		    }
break;
case 20:
       {
			yylval.sval = malloc(strlen(yytext+8)+1);
			strcpy(yylval.sval, yytext+8);
			return COMMENT;
		    }
break;
case 21:
             {
			if (stringMode) {
			    yylval.sval = malloc(strlen(yytext)+1);
			    strcpy(yylval.sval, yytext);
			    return STRING;
			} else
			    sscanf(yytext, "%d", &yylval.ival);
			return NUMBER;
		    }
break;
case 22:
            {
			sscanf(yytext, "%d", &yylval.ival);
			return NUMBER;
		    }
break;
case 23:
              {
			if (stringMode) {
			    yylval.sval = malloc(strlen(yytext)+1);
			    strcpy(yylval.sval, yytext);
			    return STRING;
			}
			sscanf(yytext, "%x", &yylval.ival);
			return NUMBER;
		    }
break;
case 24:
               {
			yylval.sval = malloc(strlen(yytext)+1);
			strcpy(yylval.sval, yytext);
			return IDENTIFIER;
		    }
break;
case 25:
                 return DOT;
break;
case 26:
             {
			yylval.sval = malloc(strlen(yytext)+1);
			strcpy(yylval.sval, yytext);
			return STRING;
		    }
break;
case 27:
                 ;
break;
case 28:
                 {
			lineno++;
			return NEWLINE;
		    }
break;
case 29:
                  ;
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

int yyvstop[] = {
0,

29,
0,

27,
29,
0,

28,
0,

29,
0,

29,
0,

25,
29,
0,

21,
23,
29,
0,

23,
24,
29,
0,

23,
24,
29,
0,

23,
24,
29,
0,

23,
24,
29,
0,

23,
24,
29,
0,

23,
24,
29,
0,

24,
29,
0,

24,
29,
0,

26,
0,

22,
0,

21,
23,
0,

23,
0,

24,
0,

23,
24,
0,

23,
24,
0,

24,
0,

24,
0,

24,
0,

23,
24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

13,
24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

23,
24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

23,
24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

2,
24,
0,

24,
0,

24,
0,

24,
0,

9,
24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

17,
0,

24,
0,

24,
0,

24,
0,

14,
24,
0,

24,
0,

24,
0,

24,
0,

12,
24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

11,
24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

15,
24,
0,

16,
24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

20,
0,

24,
0,

10,
24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

1,
24,
0,

24,
0,

18,
0,

24,
0,

24,
0,

19,
0,

24,
0,

24,
0,

24,
0,

6,
0,

24,
0,

7,
0,

24,
0,

24,
0,

5,
0,

24,
0,

8,
24,
0,

24,
0,

24,
0,

24,
0,

24,
0,

3,
24,
0,

4,
24,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
18,0,	19,0,	0,0,	6,18,	
2,4,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
6,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,6,	
18,19,	19,19,	0,0,	0,0,	
0,0,	2,6,	0,0,	0,0,	
0,0,	0,0,	1,7,	1,8,	
6,19,	1,9,	0,0,	0,0,	
0,0,	2,8,	0,0,	0,0,	
0,0,	0,0,	0,0,	6,18,	
0,0,	0,0,	6,18,	0,0,	
0,0,	0,0,	1,10,	1,11,	
1,12,	1,13,	1,14,	1,15,	
1,16,	2,11,	2,12,	2,13,	
2,14,	2,15,	29,41,	6,18,	
11,25,	12,27,	14,31,	15,32,	
1,17,	6,18,	41,53,	11,26,	
12,28,	25,36,	2,17,	7,20,	
7,20,	7,20,	7,20,	7,20,	
7,20,	7,20,	7,20,	7,20,	
7,20,	9,21,	9,21,	9,21,	
9,21,	9,21,	9,21,	9,21,	
9,21,	9,21,	9,21,	13,29,	
53,67,	75,88,	88,102,	89,103,	
75,89,	102,113,	9,22,	9,22,	
9,22,	9,22,	9,22,	9,22,	
103,114,	109,119,	113,122,	114,123,	
119,128,	13,30,	122,131,	123,132,	
128,135,	131,138,	132,139,	135,141,	
10,23,	10,23,	139,144,	10,24,	
10,24,	10,24,	10,24,	10,24,	
10,24,	10,24,	10,24,	10,24,	
10,24,	0,0,	9,22,	9,22,	
9,22,	9,22,	9,22,	9,22,	
10,24,	10,24,	10,24,	10,24,	
10,24,	10,24,	10,23,	10,23,	
10,23,	10,23,	10,23,	10,23,	
10,23,	10,23,	10,23,	10,23,	
10,23,	10,23,	10,23,	10,23,	
10,23,	10,23,	10,23,	10,23,	
10,23,	10,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
10,24,	10,24,	10,24,	10,24,	
10,24,	10,24,	10,23,	10,23,	
10,23,	10,23,	10,23,	10,23,	
10,23,	10,23,	10,23,	10,23,	
10,23,	10,23,	10,23,	10,23,	
10,23,	10,23,	10,23,	10,23,	
10,23,	10,23,	16,23,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	16,23,	16,23,	16,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	17,23,	17,23,	17,23,	
17,23,	17,23,	17,23,	17,23,	
17,23,	17,23,	17,23,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	17,23,	17,23,	
17,23,	17,23,	17,23,	17,23,	
0,0,	0,0,	17,33,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	0,0,	0,0,	73,73,	
0,0,	17,34,	0,0,	0,0,	
17,35,	0,0,	0,0,	0,0,	
73,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	17,23,	17,23,	
17,23,	17,23,	17,23,	17,23,	
22,22,	22,22,	22,22,	22,22,	
22,22,	22,22,	22,22,	22,22,	
22,22,	22,22,	23,23,	23,23,	
23,23,	23,23,	23,23,	23,23,	
23,23,	23,23,	23,23,	23,23,	
0,0,	0,0,	0,0,	73,73,	
0,0,	0,0,	73,73,	23,23,	
23,23,	23,23,	23,23,	23,23,	
23,23,	26,23,	26,23,	26,23,	
26,23,	26,23,	26,23,	26,23,	
26,23,	26,23,	26,23,	73,73,	
0,0,	0,0,	0,0,	0,0,	
0,0,	73,73,	26,23,	26,23,	
26,23,	26,23,	26,23,	26,23,	
0,0,	0,0,	0,0,	23,23,	
23,23,	23,23,	23,23,	23,23,	
23,23,	0,0,	0,0,	0,0,	
0,0,	26,37,	0,0,	27,23,	
27,23,	27,23,	27,23,	27,23,	
27,23,	27,23,	27,23,	27,23,	
27,23,	0,0,	26,23,	26,23,	
26,23,	26,23,	26,23,	26,23,	
27,38,	27,23,	27,23,	27,23,	
27,23,	27,23,	0,0,	0,0,	
0,0,	28,23,	28,23,	28,23,	
28,23,	28,23,	28,23,	28,23,	
28,23,	28,23,	28,23,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	28,23,	28,23,	
28,23,	28,23,	28,23,	28,23,	
27,23,	27,23,	27,23,	27,23,	
27,23,	27,23,	28,39,	0,0,	
0,0,	28,40,	0,0,	0,0,	
0,0,	0,0,	0,0,	30,23,	
30,23,	30,23,	30,23,	30,23,	
30,23,	30,23,	30,23,	30,23,	
30,23,	0,0,	28,23,	28,23,	
28,23,	28,23,	28,23,	28,23,	
30,23,	30,23,	30,23,	30,23,	
30,23,	30,23,	0,0,	0,0,	
30,42,	31,23,	31,23,	31,23,	
31,23,	31,23,	31,23,	31,23,	
31,23,	31,23,	31,23,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	31,23,	31,23,	
31,43,	31,44,	31,23,	31,23,	
30,23,	30,23,	30,23,	30,23,	
30,23,	30,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	32,23,	
32,23,	32,23,	32,23,	32,23,	
32,23,	32,23,	32,23,	32,23,	
32,23,	0,0,	31,23,	31,23,	
31,23,	31,23,	31,23,	31,23,	
32,23,	32,23,	32,23,	32,23,	
32,23,	32,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	32,45,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	33,23,	33,23,	33,23,	
33,23,	33,23,	33,23,	33,23,	
33,23,	33,23,	33,23,	0,0,	
32,23,	32,23,	32,23,	32,23,	
32,23,	32,23,	33,23,	33,23,	
33,23,	33,23,	33,23,	33,23,	
0,0,	0,0,	0,0,	34,23,	
34,23,	34,23,	34,23,	34,23,	
34,23,	34,23,	34,23,	34,23,	
34,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	33,46,	
34,47,	34,23,	34,23,	34,23,	
34,23,	34,23,	33,23,	33,23,	
33,23,	33,23,	33,23,	33,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	35,23,	35,23,	35,23,	
35,23,	35,23,	35,23,	35,23,	
35,23,	35,23,	35,23,	0,0,	
34,23,	34,23,	34,23,	34,23,	
34,23,	34,23,	35,23,	35,23,	
35,23,	35,23,	35,23,	35,23,	
0,0,	0,0,	35,48,	36,23,	
36,23,	36,23,	36,23,	36,23,	
36,23,	36,23,	36,23,	36,23,	
36,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
36,23,	36,23,	36,23,	36,23,	
36,23,	36,23,	35,23,	35,23,	
35,23,	35,23,	35,23,	35,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	37,23,	37,23,	37,23,	
37,23,	37,23,	37,23,	37,23,	
37,23,	37,23,	37,23,	0,0,	
36,23,	36,23,	36,23,	36,23,	
36,23,	36,23,	37,23,	37,23,	
37,23,	37,23,	37,23,	37,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	37,49,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	38,23,	
38,23,	38,23,	38,23,	38,23,	
38,23,	38,23,	38,23,	38,23,	
38,23,	0,0,	37,23,	37,23,	
37,23,	37,23,	37,23,	37,23,	
38,23,	38,23,	38,23,	38,23,	
38,23,	38,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	38,50,	0,0,	0,0,	
0,0,	39,23,	39,23,	39,23,	
39,23,	39,23,	39,23,	39,23,	
39,23,	39,23,	39,23,	0,0,	
38,23,	38,23,	38,23,	38,23,	
38,23,	38,23,	39,23,	39,23,	
39,23,	39,23,	39,23,	39,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	39,51,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	40,23,	
40,23,	40,23,	40,23,	40,23,	
40,23,	40,23,	40,23,	40,23,	
40,23,	0,0,	39,23,	39,23,	
39,23,	39,23,	39,23,	39,23,	
40,23,	40,23,	40,23,	40,23,	
40,23,	40,23,	0,0,	0,0,	
42,23,	42,23,	42,23,	42,23,	
42,23,	42,23,	42,23,	42,23,	
42,23,	42,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
40,52,	42,23,	42,23,	42,23,	
42,54,	42,23,	42,23,	0,0,	
40,23,	40,23,	40,23,	40,23,	
40,23,	40,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	43,23,	43,23,	
43,23,	43,23,	43,23,	43,23,	
43,23,	43,23,	43,23,	43,23,	
0,0,	42,23,	42,23,	42,23,	
42,23,	42,23,	42,23,	43,23,	
43,23,	43,23,	43,23,	43,23,	
43,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	43,55,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
44,23,	44,23,	44,23,	44,23,	
44,23,	44,23,	44,23,	44,23,	
44,23,	44,23,	0,0,	43,23,	
43,23,	43,23,	43,23,	43,23,	
43,23,	44,23,	44,23,	44,56,	
44,23,	44,23,	44,57,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
44,58,	0,0,	0,0,	0,0,	
0,0,	0,0,	45,23,	45,23,	
45,23,	45,23,	45,23,	45,23,	
45,23,	45,23,	45,23,	45,23,	
0,0,	44,23,	44,23,	44,23,	
44,23,	44,23,	44,23,	45,23,	
45,23,	45,23,	45,23,	45,23,	
45,23,	46,23,	46,23,	46,23,	
46,23,	46,23,	46,23,	46,23,	
46,23,	46,23,	46,23,	0,0,	
0,0,	0,0,	45,59,	0,0,	
0,0,	0,0,	46,23,	46,23,	
46,23,	46,23,	46,60,	46,23,	
0,0,	0,0,	0,0,	45,23,	
45,23,	45,23,	45,23,	45,23,	
45,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	47,23,	
47,23,	47,23,	47,23,	47,23,	
47,23,	47,23,	47,23,	47,23,	
47,23,	0,0,	46,23,	46,23,	
46,23,	46,23,	46,23,	46,23,	
47,23,	47,23,	47,23,	47,23,	
47,23,	47,23,	48,23,	48,23,	
48,23,	48,23,	48,23,	48,23,	
48,23,	48,23,	48,23,	48,23,	
0,0,	47,61,	0,0,	0,0,	
0,0,	0,0,	0,0,	48,23,	
48,23,	48,23,	48,62,	48,23,	
48,23,	0,0,	0,0,	0,0,	
47,23,	47,23,	47,23,	47,23,	
47,23,	47,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
49,23,	49,23,	49,23,	49,23,	
49,23,	49,23,	49,23,	49,23,	
49,23,	49,23,	0,0,	48,23,	
48,23,	48,23,	48,23,	48,23,	
48,23,	49,63,	49,23,	49,23,	
49,23,	49,23,	49,23,	50,23,	
50,23,	50,23,	50,23,	50,23,	
50,23,	50,23,	50,23,	50,23,	
50,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
50,23,	50,23,	50,23,	50,23,	
50,23,	50,23,	0,0,	0,0,	
0,0,	49,23,	49,23,	49,23,	
49,23,	49,23,	49,23,	0,0,	
0,0,	0,0,	50,64,	0,0,	
0,0,	51,23,	51,23,	51,23,	
51,23,	51,23,	51,23,	51,23,	
51,23,	51,23,	51,23,	0,0,	
50,23,	50,23,	50,23,	50,23,	
50,23,	50,23,	51,23,	51,23,	
51,23,	51,23,	51,65,	51,23,	
52,23,	52,23,	52,23,	52,23,	
52,23,	52,23,	52,23,	52,23,	
52,23,	52,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	52,23,	52,23,	52,23,	
52,23,	52,23,	52,23,	0,0,	
0,0,	0,0,	51,23,	51,23,	
51,23,	51,23,	51,23,	51,23,	
0,0,	0,0,	52,66,	0,0,	
0,0,	0,0,	54,23,	54,23,	
54,23,	54,23,	54,23,	54,23,	
54,23,	54,23,	54,23,	54,23,	
0,0,	52,23,	52,23,	52,23,	
52,23,	52,23,	52,23,	54,23,	
54,23,	54,23,	54,23,	54,23,	
54,23,	55,23,	55,23,	55,23,	
55,23,	55,23,	55,23,	55,23,	
55,23,	55,23,	55,23,	0,0,	
0,0,	0,0,	54,68,	0,0,	
0,0,	0,0,	55,23,	55,23,	
55,23,	55,69,	55,23,	55,23,	
0,0,	0,0,	0,0,	54,23,	
54,23,	54,23,	54,23,	54,23,	
54,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	56,23,	
56,23,	56,23,	56,23,	56,23,	
56,23,	56,23,	56,23,	56,23,	
56,23,	0,0,	55,23,	55,23,	
55,23,	55,23,	55,23,	55,23,	
56,23,	56,23,	56,23,	56,23,	
56,23,	56,23,	0,0,	56,70,	
57,23,	57,23,	57,23,	57,23,	
57,23,	57,23,	57,23,	57,23,	
57,23,	57,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	57,23,	57,23,	57,23,	
57,23,	57,23,	57,23,	0,0,	
56,23,	56,23,	56,23,	56,23,	
56,23,	56,23,	0,0,	57,71,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	58,23,	58,23,	
58,23,	58,23,	58,23,	58,23,	
58,23,	58,23,	58,23,	58,23,	
0,0,	57,23,	57,23,	57,23,	
57,23,	57,23,	57,23,	58,23,	
58,23,	58,23,	58,23,	58,23,	
58,23,	59,73,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
58,72,	0,0,	0,0,	0,0,	
0,0,	59,23,	59,23,	59,23,	
59,23,	59,23,	59,23,	59,23,	
59,23,	59,23,	59,23,	58,23,	
58,23,	58,23,	58,23,	58,23,	
58,23,	0,0,	59,23,	59,74,	
59,23,	59,23,	59,23,	59,23,	
60,23,	60,23,	60,23,	60,23,	
60,23,	60,23,	60,23,	60,23,	
60,23,	60,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	60,23,	60,23,	60,23,	
60,23,	60,23,	60,23,	0,0,	
59,75,	0,0,	59,23,	59,23,	
59,23,	59,23,	59,23,	59,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	61,23,	61,23,	
61,23,	61,23,	61,23,	61,23,	
61,23,	61,23,	61,23,	61,23,	
0,0,	60,23,	60,23,	60,23,	
60,23,	60,23,	60,23,	61,23,	
61,23,	61,23,	61,23,	61,23,	
61,23,	62,23,	62,23,	62,23,	
62,23,	62,23,	62,23,	62,23,	
62,23,	62,23,	62,23,	0,0,	
0,0,	0,0,	61,76,	0,0,	
0,0,	0,0,	62,23,	62,23,	
62,23,	62,23,	62,23,	62,23,	
0,0,	0,0,	0,0,	61,23,	
61,23,	61,23,	61,23,	61,23,	
61,23,	0,0,	0,0,	0,0,	
0,0,	62,77,	0,0,	63,23,	
63,23,	63,23,	63,23,	63,23,	
63,23,	63,23,	63,23,	63,23,	
63,23,	0,0,	62,23,	62,23,	
62,23,	62,23,	62,23,	62,23,	
63,23,	63,23,	63,23,	63,23,	
63,23,	63,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	63,78,	
0,0,	0,0,	0,0,	0,0,	
0,0,	64,23,	64,23,	64,23,	
64,23,	64,23,	64,23,	64,23,	
64,23,	64,23,	64,23,	0,0,	
63,23,	63,23,	63,23,	63,23,	
63,23,	63,23,	64,23,	64,23,	
64,23,	64,23,	64,23,	64,23,	
0,0,	0,0,	65,23,	65,23,	
65,23,	65,23,	65,23,	65,23,	
65,23,	65,23,	65,23,	65,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	65,23,	
65,23,	65,23,	65,23,	65,23,	
65,23,	0,0,	64,23,	64,23,	
64,23,	64,23,	64,23,	64,23,	
65,79,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
66,23,	66,23,	66,23,	66,23,	
66,23,	66,23,	66,23,	66,23,	
66,23,	66,23,	0,0,	65,23,	
65,23,	65,23,	65,23,	65,23,	
65,23,	66,23,	66,23,	66,23,	
66,23,	66,23,	66,23,	0,0,	
0,0,	66,80,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	67,23,	67,23,	
67,23,	67,23,	67,23,	67,23,	
67,23,	67,23,	67,23,	67,23,	
0,0,	66,23,	66,23,	66,23,	
66,23,	66,23,	66,23,	67,23,	
67,23,	67,23,	67,23,	67,23,	
67,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	67,81,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
68,23,	68,23,	68,23,	68,23,	
68,23,	68,23,	68,23,	68,23,	
68,23,	68,23,	0,0,	67,23,	
67,23,	67,23,	67,23,	67,23,	
67,23,	68,23,	68,23,	68,23,	
68,23,	68,23,	68,23,	0,0,	
68,82,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	69,23,	69,23,	
69,23,	69,23,	69,23,	69,23,	
69,23,	69,23,	69,23,	69,23,	
0,0,	68,23,	68,23,	68,23,	
68,23,	68,23,	68,23,	69,23,	
69,23,	69,23,	69,23,	69,23,	
69,23,	0,0,	0,0,	69,83,	
70,23,	70,23,	70,23,	70,23,	
70,23,	70,23,	70,23,	70,23,	
70,23,	70,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	70,84,	70,23,	70,23,	
70,23,	70,23,	70,23,	69,23,	
69,23,	69,23,	69,23,	69,23,	
69,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	71,23,	71,23,	
71,23,	71,23,	71,23,	71,23,	
71,23,	71,23,	71,23,	71,23,	
0,0,	70,23,	70,23,	70,23,	
70,23,	70,23,	70,23,	71,23,	
71,23,	71,23,	71,23,	71,23,	
71,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
71,85,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
72,23,	72,23,	72,23,	72,23,	
72,23,	72,23,	72,23,	72,23,	
72,23,	72,23,	0,0,	71,23,	
71,23,	71,23,	71,23,	71,23,	
71,23,	72,23,	72,23,	72,23,	
72,23,	72,23,	72,23,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	72,86,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	74,23,	74,23,	
74,23,	74,23,	74,23,	74,23,	
74,23,	74,23,	74,23,	74,23,	
0,0,	72,23,	72,23,	72,23,	
72,23,	72,23,	72,23,	74,23,	
74,23,	74,23,	74,23,	74,23,	
74,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	74,87,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
76,23,	76,23,	76,23,	76,23,	
76,23,	76,23,	76,23,	76,23,	
76,23,	76,23,	0,0,	74,23,	
74,23,	74,23,	74,23,	74,23,	
74,23,	76,23,	76,23,	76,90,	
76,23,	76,23,	76,91,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
76,92,	0,0,	0,0,	0,0,	
0,0,	0,0,	77,23,	77,23,	
77,23,	77,23,	77,23,	77,23,	
77,23,	77,23,	77,23,	77,23,	
0,0,	76,23,	76,23,	76,23,	
76,23,	76,23,	76,23,	77,23,	
77,23,	77,23,	77,23,	77,23,	
77,23,	0,0,	77,93,	78,23,	
78,23,	78,23,	78,23,	78,23,	
78,23,	78,23,	78,23,	78,23,	
78,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
78,23,	78,23,	78,23,	78,23,	
78,23,	78,23,	0,0,	77,23,	
77,23,	77,23,	77,23,	77,23,	
77,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	79,23,	79,23,	79,23,	
79,23,	79,23,	79,23,	79,23,	
79,23,	79,23,	79,23,	0,0,	
78,23,	78,23,	78,23,	78,23,	
78,23,	78,23,	79,23,	79,23,	
79,23,	79,23,	79,23,	79,23,	
80,23,	80,23,	80,23,	80,23,	
80,23,	80,23,	80,23,	80,23,	
80,23,	80,23,	0,0,	0,0,	
0,0,	79,94,	0,0,	0,0,	
0,0,	80,23,	80,23,	80,23,	
80,23,	80,23,	80,23,	80,95,	
0,0,	0,0,	79,23,	79,23,	
79,23,	79,23,	79,23,	79,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	81,23,	81,23,	
81,23,	81,23,	81,23,	81,23,	
81,23,	81,23,	81,23,	81,23,	
0,0,	80,23,	80,23,	80,23,	
80,23,	80,23,	80,23,	81,23,	
81,23,	81,23,	81,23,	81,23,	
81,23,	82,23,	82,23,	82,23,	
82,23,	82,23,	82,23,	82,23,	
82,23,	82,23,	82,23,	0,0,	
0,0,	0,0,	81,96,	0,0,	
0,0,	0,0,	82,23,	82,23,	
82,23,	82,23,	82,23,	82,23,	
0,0,	0,0,	0,0,	81,23,	
81,23,	81,23,	81,23,	81,23,	
81,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	83,23,	
83,23,	83,23,	83,23,	83,23,	
83,23,	83,23,	83,23,	83,23,	
83,23,	0,0,	82,23,	82,23,	
82,23,	82,23,	82,23,	82,23,	
83,23,	83,23,	83,23,	83,23,	
83,23,	83,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	83,97,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	84,23,	84,23,	84,23,	
84,23,	84,23,	84,23,	84,23,	
84,23,	84,23,	84,23,	0,0,	
83,23,	83,23,	83,23,	83,23,	
83,23,	83,23,	84,23,	84,23,	
84,23,	84,23,	84,23,	84,23,	
85,23,	85,23,	85,23,	85,23,	
85,23,	85,23,	85,23,	85,23,	
85,23,	85,23,	0,0,	84,98,	
0,0,	0,0,	0,0,	0,0,	
0,0,	85,23,	85,23,	85,23,	
85,23,	85,23,	85,23,	0,0,	
0,0,	0,0,	84,23,	84,23,	
84,23,	84,23,	84,23,	84,23,	
0,0,	0,0,	0,0,	0,0,	
85,99,	0,0,	86,23,	86,23,	
86,23,	86,23,	86,23,	86,23,	
86,23,	86,23,	86,23,	86,23,	
0,0,	85,23,	85,23,	85,23,	
85,23,	85,23,	85,23,	86,23,	
86,23,	86,23,	86,23,	86,23,	
86,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	86,100,	0,0,	
0,0,	0,0,	0,0,	0,0,	
87,23,	87,23,	87,23,	87,23,	
87,23,	87,23,	87,23,	87,23,	
87,23,	87,23,	0,0,	86,23,	
86,23,	86,23,	86,23,	86,23,	
86,23,	87,23,	87,23,	87,23,	
87,23,	87,23,	87,23,	90,23,	
90,23,	90,23,	90,23,	90,23,	
90,23,	90,23,	90,23,	90,23,	
90,23,	0,0,	0,0,	0,0,	
0,0,	87,101,	0,0,	0,0,	
90,23,	90,23,	90,23,	90,23,	
90,23,	90,23,	0,0,	90,104,	
0,0,	87,23,	87,23,	87,23,	
87,23,	87,23,	87,23,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	91,23,	91,23,	91,23,	
91,23,	91,23,	91,23,	91,23,	
91,23,	91,23,	91,23,	0,0,	
90,23,	90,23,	90,23,	90,23,	
90,23,	90,23,	91,23,	91,23,	
91,23,	91,23,	91,23,	91,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
91,105,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	92,23,	
92,23,	92,23,	92,23,	92,23,	
92,23,	92,23,	92,23,	92,23,	
92,23,	0,0,	91,23,	91,23,	
91,23,	91,23,	91,23,	91,23,	
92,23,	92,23,	92,23,	92,23,	
92,23,	92,23,	93,23,	93,23,	
93,23,	93,23,	93,23,	93,23,	
93,23,	93,23,	93,23,	93,23,	
0,0,	92,106,	0,0,	0,0,	
0,0,	0,0,	0,0,	93,23,	
93,23,	93,23,	93,23,	93,23,	
93,23,	94,107,	0,0,	0,0,	
92,23,	92,23,	92,23,	92,23,	
92,23,	92,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	94,23,	94,23,	94,23,	
94,23,	94,23,	94,23,	94,23,	
94,23,	94,23,	94,23,	93,23,	
93,23,	93,23,	93,23,	93,23,	
93,23,	0,0,	94,23,	94,23,	
94,23,	94,23,	94,23,	94,23,	
95,23,	95,23,	95,23,	95,23,	
95,23,	95,23,	95,23,	95,23,	
95,23,	95,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	95,23,	95,23,	95,23,	
95,23,	95,23,	95,23,	0,0,	
95,108,	0,0,	94,23,	94,23,	
94,23,	94,23,	94,23,	94,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	96,23,	96,23,	
96,23,	96,23,	96,23,	96,23,	
96,23,	96,23,	96,23,	96,23,	
0,0,	95,23,	95,23,	95,23,	
95,23,	95,23,	95,23,	96,23,	
96,23,	96,23,	96,23,	96,23,	
96,23,	97,23,	97,23,	97,23,	
97,23,	97,23,	97,23,	97,23,	
97,23,	97,23,	97,23,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	97,23,	97,23,	
97,23,	97,23,	97,23,	97,23,	
97,110,	96,109,	0,0,	96,23,	
96,23,	96,23,	96,23,	96,23,	
96,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	98,23,	
98,23,	98,23,	98,23,	98,23,	
98,23,	98,23,	98,23,	98,23,	
98,23,	0,0,	97,23,	97,23,	
97,23,	97,23,	97,23,	97,23,	
98,23,	98,23,	98,23,	98,23,	
98,23,	98,23,	99,23,	99,23,	
99,23,	99,23,	99,23,	99,23,	
99,23,	99,23,	99,23,	99,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	99,23,	
99,23,	99,23,	99,23,	99,23,	
99,23,	0,0,	0,0,	0,0,	
98,23,	98,23,	98,23,	98,23,	
98,23,	98,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
100,23,	100,23,	100,23,	100,23,	
100,23,	100,23,	100,23,	100,23,	
100,23,	100,23,	0,0,	99,23,	
99,23,	99,23,	99,23,	99,23,	
99,23,	100,23,	100,23,	100,23,	
100,23,	100,111,	100,23,	0,0,	
0,0,	101,23,	101,23,	101,23,	
101,23,	101,23,	101,23,	101,23,	
101,23,	101,23,	101,23,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	101,23,	101,23,	
101,23,	101,23,	101,23,	101,23,	
0,0,	100,23,	100,23,	100,23,	
100,23,	100,23,	100,23,	101,112,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	104,23,	
104,23,	104,23,	104,23,	104,23,	
104,23,	104,23,	104,23,	104,23,	
104,23,	0,0,	101,23,	101,23,	
101,23,	101,23,	101,23,	101,23,	
104,115,	104,23,	104,23,	104,23,	
104,23,	104,23,	0,0,	0,0,	
105,23,	105,23,	105,23,	105,23,	
105,23,	105,23,	105,23,	105,23,	
105,23,	105,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	105,23,	105,23,	105,23,	
105,23,	105,23,	105,23,	0,0,	
104,23,	104,23,	104,23,	104,23,	
104,23,	104,23,	105,116,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	106,23,	106,23,	
106,23,	106,23,	106,23,	106,23,	
106,23,	106,23,	106,23,	106,23,	
0,0,	105,23,	105,23,	105,23,	
105,23,	105,23,	105,23,	106,23,	
106,23,	106,23,	106,23,	106,23,	
106,23,	107,107,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	106,117,	107,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	106,23,	
106,23,	106,23,	106,23,	106,23,	
106,23,	108,23,	108,23,	108,23,	
108,23,	108,23,	108,23,	108,23,	
108,23,	108,23,	108,23,	0,0,	
0,0,	107,107,	0,0,	0,0,	
107,107,	0,0,	108,23,	108,23,	
108,23,	108,23,	108,23,	108,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	107,107,	0,0,	0,0,	
0,0,	108,118,	0,0,	107,107,	
110,23,	110,23,	110,23,	110,23,	
110,23,	110,23,	110,23,	110,23,	
110,23,	110,23,	108,23,	108,23,	
108,23,	108,23,	108,23,	108,23,	
0,0,	110,23,	110,23,	110,23,	
110,23,	110,23,	110,23,	111,23,	
111,23,	111,23,	111,23,	111,23,	
111,23,	111,23,	111,23,	111,23,	
111,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
111,23,	111,23,	111,23,	111,23,	
111,23,	111,23,	0,0,	0,0,	
0,0,	110,23,	110,23,	110,23,	
110,23,	110,23,	110,23,	0,0,	
0,0,	111,120,	0,0,	0,0,	
0,0,	112,23,	112,23,	112,23,	
112,23,	112,23,	112,23,	112,23,	
112,23,	112,23,	112,23,	0,0,	
111,23,	111,23,	111,23,	111,23,	
111,23,	111,23,	112,23,	112,23,	
112,23,	112,121,	112,23,	112,23,	
115,23,	115,23,	115,23,	115,23,	
115,23,	115,23,	115,23,	115,23,	
115,23,	115,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	115,23,	115,23,	115,23,	
115,23,	115,23,	115,23,	0,0,	
0,0,	0,0,	112,23,	112,23,	
112,23,	112,23,	112,23,	112,23,	
0,0,	0,0,	115,124,	0,0,	
0,0,	0,0,	116,23,	116,23,	
116,23,	116,23,	116,23,	116,23,	
116,23,	116,23,	116,23,	116,23,	
0,0,	115,23,	115,23,	115,23,	
115,23,	115,23,	115,23,	116,23,	
116,23,	116,23,	116,23,	116,23,	
116,23,	117,23,	117,23,	117,23,	
117,23,	117,23,	117,23,	117,23,	
117,23,	117,23,	117,23,	0,0,	
0,0,	0,0,	116,125,	0,0,	
0,0,	0,0,	117,23,	117,23,	
117,23,	117,23,	117,23,	117,23,	
118,127,	0,0,	0,0,	116,23,	
116,23,	116,23,	116,23,	116,23,	
116,23,	117,126,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
118,23,	118,23,	118,23,	118,23,	
118,23,	118,23,	118,23,	118,23,	
118,23,	118,23,	117,23,	117,23,	
117,23,	117,23,	117,23,	117,23,	
0,0,	118,23,	118,23,	118,23,	
118,23,	118,23,	118,23,	120,23,	
120,23,	120,23,	120,23,	120,23,	
120,23,	120,23,	120,23,	120,23,	
120,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
120,23,	120,23,	120,23,	120,23,	
120,23,	120,23,	0,0,	0,0,	
0,0,	118,23,	118,23,	118,23,	
118,23,	118,23,	118,23,	0,0,	
0,0,	0,0,	0,0,	120,129,	
0,0,	121,23,	121,23,	121,23,	
121,23,	121,23,	121,23,	121,23,	
121,23,	121,23,	121,23,	124,133,	
120,23,	120,23,	120,23,	120,23,	
120,23,	120,23,	121,23,	121,23,	
121,23,	121,23,	121,23,	121,23,	
0,0,	0,0,	121,130,	124,23,	
124,23,	124,23,	124,23,	124,23,	
124,23,	124,23,	124,23,	124,23,	
124,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
124,23,	124,23,	124,23,	124,23,	
124,23,	124,23,	121,23,	121,23,	
121,23,	121,23,	121,23,	121,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	125,23,	125,23,	125,23,	
125,23,	125,23,	125,23,	125,23,	
125,23,	125,23,	125,23,	0,0,	
124,23,	124,23,	124,23,	124,23,	
124,23,	124,23,	125,23,	125,23,	
125,23,	125,23,	125,23,	125,23,	
126,23,	126,23,	126,23,	126,23,	
126,23,	126,23,	126,23,	126,23,	
126,23,	126,23,	0,0,	0,0,	
0,0,	0,0,	127,127,	0,0,	
0,0,	126,23,	126,23,	126,23,	
126,23,	126,134,	126,23,	127,0,	
0,0,	0,0,	125,23,	125,23,	
125,23,	125,23,	125,23,	125,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	126,23,	126,23,	126,23,	
126,23,	126,23,	126,23,	0,0,	
0,0,	0,0,	127,127,	0,0,	
0,0,	127,127,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
129,23,	129,23,	129,23,	129,23,	
129,23,	129,23,	129,23,	129,23,	
129,23,	129,23,	127,127,	0,0,	
0,0,	0,0,	0,0,	0,0,	
127,127,	129,23,	129,23,	129,23,	
129,23,	129,23,	129,23,	0,0,	
0,0,	129,136,	130,23,	130,23,	
130,23,	130,23,	130,23,	130,23,	
130,23,	130,23,	130,23,	130,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	130,23,	
130,23,	130,23,	130,23,	130,23,	
130,23,	129,23,	129,23,	129,23,	
129,23,	129,23,	129,23,	133,133,	
130,137,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
133,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	130,23,	
130,23,	130,23,	130,23,	130,23,	
130,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	134,23,	134,23,	
134,23,	134,23,	134,23,	134,23,	
134,23,	134,23,	134,23,	134,23,	
0,0,	0,0,	0,0,	133,133,	
0,0,	0,0,	133,133,	134,23,	
134,23,	134,23,	134,23,	134,23,	
134,23,	136,23,	136,23,	136,23,	
136,23,	136,23,	136,23,	136,23,	
136,23,	136,23,	136,23,	133,133,	
134,140,	0,0,	0,0,	0,0,	
0,0,	133,133,	136,23,	136,23,	
136,23,	136,23,	136,142,	136,23,	
0,0,	0,0,	0,0,	134,23,	
134,23,	134,23,	134,23,	134,23,	
134,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	137,23,	
137,23,	137,23,	137,23,	137,23,	
137,23,	137,23,	137,23,	137,23,	
137,23,	0,0,	136,23,	136,23,	
136,23,	136,23,	136,23,	136,23,	
137,23,	137,23,	137,23,	137,23,	
137,23,	137,23,	137,143,	140,23,	
140,23,	140,23,	140,23,	140,23,	
140,23,	140,23,	140,23,	140,23,	
140,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
140,23,	140,23,	140,23,	140,23,	
140,23,	140,23,	0,0,	0,0,	
137,23,	137,23,	137,23,	137,23,	
137,23,	137,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	140,145,	
0,0,	142,23,	142,23,	142,23,	
142,23,	142,23,	142,23,	142,23,	
142,23,	142,23,	142,23,	0,0,	
140,23,	140,23,	140,23,	140,23,	
140,23,	140,23,	142,23,	142,23,	
142,23,	142,23,	142,23,	142,23,	
143,23,	143,23,	143,23,	143,23,	
143,23,	143,23,	143,23,	143,23,	
143,23,	143,23,	0,0,	0,0,	
142,146,	0,0,	0,0,	0,0,	
0,0,	143,23,	143,147,	143,23,	
143,23,	143,23,	143,23,	0,0,	
0,0,	0,0,	142,23,	142,23,	
142,23,	142,23,	142,23,	142,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	145,23,	145,23,	
145,23,	145,23,	145,23,	145,23,	
145,23,	145,23,	145,23,	145,23,	
0,0,	143,23,	143,23,	143,23,	
143,23,	143,23,	143,23,	145,23,	
145,23,	145,23,	145,23,	145,23,	
145,23,	0,0,	0,0,	145,148,	
146,23,	146,23,	146,23,	146,23,	
146,23,	146,23,	146,23,	146,23,	
146,23,	146,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	146,23,	146,23,	146,23,	
146,23,	146,23,	146,23,	145,23,	
145,23,	145,23,	145,23,	145,23,	
145,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	147,23,	147,23,	
147,23,	147,23,	147,23,	147,23,	
147,23,	147,23,	147,23,	147,23,	
0,0,	146,23,	146,23,	146,23,	
146,23,	146,23,	146,23,	147,23,	
147,23,	147,23,	147,23,	147,23,	
147,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	147,149,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
148,23,	148,23,	148,23,	148,23,	
148,23,	148,23,	148,23,	148,23,	
148,23,	148,23,	0,0,	147,23,	
147,23,	147,23,	147,23,	147,23,	
147,23,	148,23,	148,23,	148,23,	
148,23,	148,150,	148,23,	149,23,	
149,23,	149,23,	149,23,	149,23,	
149,23,	149,23,	149,23,	149,23,	
149,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
149,23,	149,23,	149,23,	149,23,	
149,23,	149,23,	0,0,	0,0,	
0,0,	148,23,	148,23,	148,23,	
148,23,	148,23,	148,23,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	149,151,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
149,23,	149,23,	149,23,	149,23,	
149,23,	149,23,	150,23,	150,23,	
150,23,	150,23,	150,23,	150,23,	
150,23,	150,23,	150,23,	150,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	150,23,	
150,23,	150,23,	150,23,	150,23,	
150,23,	151,23,	151,23,	151,23,	
151,23,	151,23,	151,23,	151,23,	
151,23,	151,23,	151,23,	0,0,	
0,0,	150,152,	0,0,	0,0,	
0,0,	0,0,	151,23,	151,23,	
151,23,	151,23,	151,23,	151,23,	
0,0,	0,0,	0,0,	150,23,	
150,23,	150,23,	150,23,	150,23,	
150,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	152,23,	
152,23,	152,23,	152,23,	152,23,	
152,23,	152,23,	152,23,	152,23,	
152,23,	0,0,	151,23,	151,23,	
151,23,	151,23,	151,23,	151,23,	
152,23,	152,23,	152,23,	152,23,	
152,23,	152,23,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
152,23,	152,23,	152,23,	152,23,	
152,23,	152,23,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-7,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+3,
yycrank+0,	0,		yyvstop+6,
yycrank+-14,	0,		yyvstop+8,
yycrank+43,	0,		yyvstop+10,
yycrank+0,	0,		yyvstop+12,
yycrank+53,	0,		yyvstop+15,
yycrank+91,	0,		yyvstop+19,
yycrank+14,	yysvec+10,	yyvstop+23,
yycrank+9,	yysvec+10,	yyvstop+27,
yycrank+42,	yysvec+10,	yyvstop+31,
yycrank+4,	yysvec+10,	yyvstop+35,
yycrank+4,	yysvec+10,	yyvstop+39,
yycrank+166,	yysvec+10,	yyvstop+43,
yycrank+189,	yysvec+10,	yyvstop+46,
yycrank+-2,	yysvec+6,	0,	
yycrank+-3,	yysvec+6,	yyvstop+49,
yycrank+0,	yysvec+7,	yyvstop+51,
yycrank+0,	yysvec+9,	yyvstop+53,
yycrank+244,	yysvec+9,	yyvstop+56,
yycrank+254,	yysvec+10,	yyvstop+58,
yycrank+0,	yysvec+10,	yyvstop+60,
yycrank+1,	yysvec+10,	yyvstop+63,
yycrank+277,	yysvec+10,	yyvstop+66,
yycrank+315,	yysvec+10,	yyvstop+68,
yycrank+341,	yysvec+10,	yyvstop+70,
yycrank+8,	yysvec+10,	yyvstop+72,
yycrank+379,	yysvec+10,	yyvstop+75,
yycrank+405,	yysvec+10,	yyvstop+77,
yycrank+443,	yysvec+10,	yyvstop+79,
yycrank+481,	yysvec+10,	yyvstop+81,
yycrank+507,	yysvec+10,	yyvstop+83,
yycrank+545,	yysvec+10,	yyvstop+85,
yycrank+571,	yysvec+10,	yyvstop+87,
yycrank+609,	yysvec+10,	yyvstop+90,
yycrank+647,	yysvec+10,	yyvstop+92,
yycrank+685,	yysvec+10,	yyvstop+94,
yycrank+723,	yysvec+10,	yyvstop+96,
yycrank+21,	yysvec+10,	yyvstop+98,
yycrank+748,	yysvec+10,	yyvstop+101,
yycrank+786,	yysvec+10,	yyvstop+103,
yycrank+824,	yysvec+10,	yyvstop+105,
yycrank+862,	yysvec+10,	yyvstop+107,
yycrank+885,	yysvec+10,	yyvstop+109,
yycrank+923,	yysvec+10,	yyvstop+111,
yycrank+946,	yysvec+10,	yyvstop+113,
yycrank+984,	yysvec+10,	yyvstop+115,
yycrank+1007,	yysvec+10,	yyvstop+117,
yycrank+1045,	yysvec+10,	yyvstop+119,
yycrank+1068,	yysvec+10,	yyvstop+121,
yycrank+27,	yysvec+10,	yyvstop+123,
yycrank+1106,	yysvec+10,	yyvstop+126,
yycrank+1129,	yysvec+10,	yyvstop+128,
yycrank+1167,	yysvec+10,	yyvstop+130,
yycrank+1192,	yysvec+10,	yyvstop+132,
yycrank+1230,	yysvec+10,	yyvstop+134,
yycrank+1269,	yysvec+10,	yyvstop+136,
yycrank+1292,	yysvec+10,	yyvstop+138,
yycrank+1330,	yysvec+10,	yyvstop+141,
yycrank+1353,	yysvec+10,	yyvstop+143,
yycrank+1391,	yysvec+10,	yyvstop+145,
yycrank+1429,	yysvec+10,	yyvstop+147,
yycrank+1454,	yysvec+10,	yyvstop+150,
yycrank+1492,	yysvec+10,	yyvstop+152,
yycrank+1530,	yysvec+10,	yyvstop+154,
yycrank+1568,	yysvec+10,	yyvstop+156,
yycrank+1606,	yysvec+10,	yyvstop+158,
yycrank+1632,	yysvec+10,	yyvstop+160,
yycrank+1670,	yysvec+10,	yyvstop+162,
yycrank+1708,	yysvec+10,	yyvstop+164,
yycrank+-270,	0,		yyvstop+166,
yycrank+1746,	yysvec+10,	yyvstop+168,
yycrank+48,	0,		0,	
yycrank+1784,	yysvec+10,	yyvstop+170,
yycrank+1822,	yysvec+10,	yyvstop+172,
yycrank+1847,	yysvec+10,	yyvstop+174,
yycrank+1885,	yysvec+10,	yyvstop+177,
yycrank+1908,	yysvec+10,	yyvstop+179,
yycrank+1946,	yysvec+10,	yyvstop+181,
yycrank+1969,	yysvec+10,	yyvstop+183,
yycrank+2007,	yysvec+10,	yyvstop+186,
yycrank+2045,	yysvec+10,	yyvstop+188,
yycrank+2068,	yysvec+10,	yyvstop+190,
yycrank+2106,	yysvec+10,	yyvstop+192,
yycrank+2144,	yysvec+10,	yyvstop+194,
yycrank+31,	0,		0,	
yycrank+46,	0,		0,	
yycrank+2167,	yysvec+10,	yyvstop+196,
yycrank+2205,	yysvec+10,	yyvstop+198,
yycrank+2243,	yysvec+10,	yyvstop+200,
yycrank+2266,	yysvec+10,	yyvstop+202,
yycrank+2305,	yysvec+10,	yyvstop+205,
yycrank+2328,	yysvec+10,	yyvstop+207,
yycrank+2366,	yysvec+10,	yyvstop+209,
yycrank+2389,	yysvec+10,	yyvstop+211,
yycrank+2427,	yysvec+10,	yyvstop+213,
yycrank+2450,	yysvec+10,	yyvstop+216,
yycrank+2488,	yysvec+10,	yyvstop+219,
yycrank+2513,	yysvec+10,	yyvstop+221,
yycrank+50,	0,		0,	
yycrank+41,	0,		0,	
yycrank+2551,	yysvec+10,	yyvstop+223,
yycrank+2576,	yysvec+10,	yyvstop+225,
yycrank+2614,	yysvec+10,	yyvstop+227,
yycrank+-2684,	0,		yyvstop+229,
yycrank+2669,	yysvec+10,	yyvstop+231,
yycrank+58,	0,		0,	
yycrank+2708,	yysvec+10,	yyvstop+233,
yycrank+2731,	yysvec+10,	yyvstop+236,
yycrank+2769,	yysvec+10,	yyvstop+238,
yycrank+57,	0,		0,	
yycrank+60,	0,		0,	
yycrank+2792,	yysvec+10,	yyvstop+240,
yycrank+2830,	yysvec+10,	yyvstop+242,
yycrank+2853,	yysvec+10,	yyvstop+244,
yycrank+2892,	yysvec+10,	yyvstop+246,
yycrank+56,	0,		0,	
yycrank+2915,	yysvec+10,	yyvstop+248,
yycrank+2953,	yysvec+10,	yyvstop+250,
yycrank+52,	0,		0,	
yycrank+62,	0,		0,	
yycrank+2979,	yysvec+10,	yyvstop+252,
yycrank+3017,	yysvec+10,	yyvstop+254,
yycrank+3040,	yysvec+10,	yyvstop+257,
yycrank+-3101,	0,		yyvstop+259,
yycrank+67,	0,		0,	
yycrank+3108,	yysvec+10,	yyvstop+261,
yycrank+3134,	yysvec+10,	yyvstop+263,
yycrank+49,	0,		0,	
yycrank+56,	0,		0,	
yycrank+-3210,	0,		yyvstop+265,
yycrank+3194,	yysvec+10,	yyvstop+267,
yycrank+53,	0,		0,	
yycrank+3217,	yysvec+10,	yyvstop+269,
yycrank+3255,	yysvec+10,	yyvstop+271,
yycrank+0,	0,		yyvstop+273,
yycrank+54,	0,		0,	
yycrank+3279,	yysvec+10,	yyvstop+275,
yycrank+0,	0,		yyvstop+277,
yycrank+3317,	yysvec+10,	yyvstop+279,
yycrank+3340,	yysvec+10,	yyvstop+281,
yycrank+0,	0,		yyvstop+283,
yycrank+3378,	yysvec+10,	yyvstop+285,
yycrank+3404,	yysvec+10,	yyvstop+287,
yycrank+3442,	yysvec+10,	yyvstop+290,
yycrank+3480,	yysvec+10,	yyvstop+292,
yycrank+3503,	yysvec+10,	yyvstop+294,
yycrank+3558,	yysvec+10,	yyvstop+296,
yycrank+3581,	yysvec+10,	yyvstop+298,
yycrank+3619,	yysvec+10,	yyvstop+301,
0,	0,	0};
struct yywork *yytop = yycrank+3721;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,'-' ,'-' ,01  ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'G' ,01  ,01  ,01  ,01  ,01  ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'G' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
