/******************************************************************************/
/**									     **/
/**		      Copyright 1989 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name of The Department of Computer Science,  **/
/** University College London not be used in advsrtising or publicity of the **/
/** software without specific, written prior permission.		     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.0 24/11/89
 *
 * pgm 
 *
 * 
 ******************************************************************************/


#include "mike_display.h"
#include "everything.h"


extern confres *conf;


/* function that draws an individual layer in the graphic window.  Takes 
 * the full area, unless a connection matrix being shown, in which case 
 * the horizontal shrinks to half the window width. - needs to be passed
 * an area_width which is half that of xwa.width
 */

void draw_neuron(w, gc, cmap, mikepath, area_width, win_height, neuron_low_color, neuron_high_color)
Widget w;
GC gc;
Colormap cmap;
int *mikepath;
int area_width;
int win_height;
char neuron_low_color;
char neuron_high_color;
{
	int i, j;
	int number_input_synapses;
	int neuron_x_position;
	int neuron_y_position;
	int synapse_height;
	rpcsys *rpcconf;
	char textlabel[512];
	float *first_attribute;
	float *weight_attribute;
	int number_of_shades = 20;

	rpcconf = conf->confres_u.sys;
	

	first_attribute = (float *) calloc(sizeof(float), 1);
	SetToState(mikepath, first_attribute);

 

	/* first we draw the neuron itself.  keep the position because we want to connect synapses to it
	 * with lines, drawn in my foreground color
	 */
	 
	neuron_x_position = ((19*area_width)/40);
	neuron_y_position = ((19*win_height)/40);

/*	set_color(w, mikepath, gc, cmap, neuron_low_color, neuron_high_color, 0.75);*/
	set_color(w, mikepath, gc, cmap, neuron_low_color, neuron_high_color, first_attribute[0]);
	XSetForeground(dpy, gc, my_drawing_color.pixel);
	XFillRectangle(dpy, gra_win, gc, neuron_x_position, neuron_y_position, (area_width/20), (win_height/20));
	XSetForeground(dpy, gc, my_fg.pixel);
	XDrawRectangle(dpy, gra_win, gc, neuron_x_position-2, neuron_y_position-2, (area_width/20)+4, (win_height/20)+4);
	/************
	 * LABEL
	 */
	free(first_attribute);


	 /* for drawing lines to we want to join to the middle of the left side at first, so manipulate 
	  *  the position a bit - not good programming I know
	  */
	if(mikepath[1] >0)
	{
/*		number_input_synapses = rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[mikepath[1]].rpclay_val[mikepath[2]].rpcclu_val[mikepath[3]].rpcneu_len;*/
/* temp at the mo */
		number_input_synapses = 20;

		weight_attribute = (float *) calloc(sizeof(float), number_input_synapses);
/*		SetToWeight(mikepath, weight_attribute);*/
		neuron_y_position += area_width/40;
		synapse_height = (win_height-60)/(number_input_synapses +2);
		XSetLineAttributes(dpy, gc, 0, LineSolid, CapRound, JoinMiter);

/* check to see if connection with previous layer - at the mo, as only have one net, if this is layer 0, 
 * cannot show synapse weights 
 */
		for(i=0; i<number_input_synapses; i++)
		{	
			set_color(w, mikepath, gc, cmap, neuron_low_color, neuron_high_color, weight_attribute[i]);
			XSetForeground(dpy, gc, my_drawing_color.pixel);
		        XFillRectangle(dpy, gra_win, gc, (area_width/4), (synapse_height *(i+1)), (area_width/20), ((9*synapse_height)/10));
			if(synapse_height > 10)
			{
				XSetForeground(dpy, gc, my_fg.pixel);
				XDrawLine(dpy, gra_win, gc, (12*(area_width)/40), (((synapse_height *(i+1)))+(synapse_height/2)), neuron_x_position, neuron_y_position-(win_height/10));
			}
		}

	/* now draw the ouput synapse for the neuron */

		set_color(w, mikepath, gc, cmap, neuron_low_color, neuron_high_color, (0.025*i));
		XSetForeground(dpy, gc, my_drawing_color.pixel);
		XFillRectangle(dpy, gra_win, gc, (3*area_width)/4, ((19*win_height)/40), (area_width/20), (win_height/20));
		XSetForeground(dpy, gc, my_fg.pixel);
		XDrawLine(dpy, gra_win, gc, (21*area_width)/40, win_height/2, ((3*area_width)/4)-1,  win_height/2);


		shade_scale(w, mikepath, neuron_low_color, neuron_high_color, number_of_shades);
		XSetForeground(dpy, gc, my_fg.pixel);
		sprintf(textlabel, "%c ->  %c  Shading", neuron_low_color, neuron_high_color);
		XDrawImageString(dpy, gra_win, gc, 5, win_height -5, textlabel, strlen(textlabel));

	        sprintf(textlabel, "net[%i].layer[%i].cluster[%i].neuron[%i]", mikepath[0], mikepath[1], mikepath[2], mikepath[3]);
        	XDrawImageString(dpy, gra_win, gc, (area_width - 10 - strlen(textlabel)), win_height -5, textlabel, strlen(textlabel));
	}
	else
	{
		/* can't draw the synapses of layer0 yet */
		Error(20);
	}
	XDrawImageString(dpy, gra_win, gc, 20, 20, "Example Window only, not yet implemented", strlen("Example Window only, not yet implemented"));
	return ;
}
