/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * SparseWeight.c
 ******************************************************************************/

#include "everything.h"
#include <ctype.h>  /* This one is for STATE etc.. to be known here */
#include "rpcheader.h"  /* OR IS IT THIS ONE ?? */

#define rpc_free(x, p) if(p)xdr_free(x, p)

/*----------------------------------------------------------*/
/* THIS PROC CALLS THE RPC WHICH GIVES THE SPARSE CONNECTION WEIGHT */
/* COMMENTS : To get the weights you access LAYER level  */
/* 	      the RPC at the NEURON TO level */
/* 			 the CLUSTER FROM level */
/*----------------------------------------------------------*/

/* EXTERN for the RPC */
extern char server[] ;
extern CLIENT *myclient ;
static rec *sparseres;

/* The configuration of the loaded nC neural network */
/* NB obtained via RPC call */
extern confres *conf ;

/* Global Variables => Highest and Lowest value */
static  float highest = 0 ;
static  float lowest = 0 ;

/*----------------------------------------------------------*/
/* Get the weight according to the path */

  void SetSparseWeight(frompath, topath , sparsefill , thesize)
  int frompath[4] ; /* Cluster FROM */
  int topath[4] ;   /* Neuron TO */
  float sparsefill[] ;
  int thesize ; /* the size of the array */
  {
  int i ;
  int floating_number ;
/* declaration for RPC only SHOULD CHANGE */
  roadsize rpcpara; 

/* set the argument to be given to the RPC */
 for (i = 0 ; i < 4 ; i++)
  {
  rpcpara.toroad[i] = topath[i] ;
  rpcpara.fromroad[i] = frompath[i] ;
  } ;

  rpcpara.size = thesize ;

/* free before calling */
rpc_free(xdr_rec, sparseres);

/* call to the RPC */
sparseres = rgetsparse_1(&rpcpara, myclient);

/* check the result */
/* 1- error from the client-server system */
 if (sparseres == NULL ) 
     {
   clnt_perror(myclient, server);
   return;
       } ;
/* 2- error from the RPC itself */
if (sparseres->errorn == -1)
       {
       Error(200) ;
       return ;
       } ;

if (sparseres->errorn != 4 && sparseres->errorn != -1)
        {
       Error(200) ;
       return ;
       } ;


/* Here I should have the information in RES pointer to type rec  */
   /*  do whatever necessary  */

 floating_number = sparseres->rec_u.sttwgt.farray_len ;


/* try to get the real staff ie VALUE themselves */
  for (i = 0 ; i < floating_number ; i++)
     {
     sparsefill[i] = sparseres->rec_u.sttwgt.farray_val[i] ;
     if (highest < sparsefill[i]) highest = sparsefill[i] ;
     if (lowest > sparsefill[i]) lowest = sparsefill[i] ;
     } ;

/* if the scale is none => put a default one */
  if (highest == lowest) highest = lowest +1 ;

}

