/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.01 30/1/90
 *
 * pgm 
 *
 * Patset_control.c
 ******************************************************************************/

#include "everything.h"
#include "myheader.h"

/*----------------------------------------------*/
/* THIS PROC DEALS WITH				*/
/* 	1- The creation of the PATSET button    */
/*	3- The effect = call Take_input 	*/
/* 			 which will take the filename.I */
/*----------------------------------------------*/



/*----------------------------------------------*/
/* EXTERN for the 1- father widget		*/
/* 	          2- neighbour(s) within the form	*/
/* 		  3- the created widget itself 	*/
/*				IO           */
extern Widget simulation ;
extern Widget title_simulation ;
extern Widget highlevel;
extern Widget patset;

/*----------------------------------------------*/
/* CALL BACK OF THE COMMAND PATTERNS LOAD     */
/*---------------------------------------------*/

  void Patset_callback(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  /* used as thepopup but no interest at the moment*/
  caddr_t call_data;     /* not used  */
  {

/* if no algorithm and/or sytem-configuration => error */
 if (!my_algorithm || !my_configuration)
           { Error(14) ; return ; } ;

/* user has the right to overwrite input patterns */
 	Take_input(initiateur,3) ; 
  }

 
/*----------------------------------------------
 * CREATION OF THE PATSET command widget (proc name= Patset)
/*----------------------------------------------*/

/*-----------------------------------------------------*/
/* ARGUMENTS FOR PATSET widget				*/
/*-----------------------------------------------------*/

/* callback for widget */
	static XtCallbackRec patsetcallback[] = {
		{Patset_callback, NULL},
		{NULL, NULL},
	};


/* Args for patset widget */
	Arg patset_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNcallback, (XtArgVal)patsetcallback},
                {XtNhighlightThickness, (XtArgVal)3},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
                {XtNhorizDistance, (XtArgVal)4},
                {XtNvertDistance, (XtArgVal)2},
                {XtNwidth, (XtArgVal)2*BUTTON_WIDTH},
                {XtNheight, (XtArgVal)BUTTON_HEIGHT},
                {XtNsensitive, (XtArgVal)False},
        };

/*-----------------------------------------------------*/
/* CREATION OF THE IO AND TOP_CONTROL			*/
/*-----------------------------------------------------*/
  void Patset()
  {


/* BTN1UP = DEFAULT + RESET otherwise does not unhighlight */
/* Declaration of the translation table for init */
  static String menu_trans = "<Btn1Up>: notify() unset() reset()" ;
  XtTranslations menu_compiled ;

 XtSetArg(patset_arg[0],XtNfromVert, title_simulation) ;
 XtSetArg(patset_arg[1],XtNfromHoriz, highlevel) ;

        patset= XtCreateManagedWidget(" Training Set ",
                                commandWidgetClass,
                                simulation,
                                patset_arg,
                                XtNumber(patset_arg));

/* Compilation of the translation table for IO */
  menu_compiled = XtParseTranslationTable(menu_trans) ;
  XtOverrideTranslations(patset, menu_compiled) ;


/* "Compile" the call back */
XtAddCallback(patset, XtNcallback,
        Patset_callback,(caddr_t)patset) ;
/* quite useless to pass input_output */

} 
