/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.01 30/1/90
 *
 * pgm 
 *
 * LoadSave_control.c
 ******************************************************************************/

#include "everything.h"
#include "myheader.h"

/*----------------------------------------------*/
/* THIS FILE DEALS WITH				*/
/* 	1- The creation of the LOAD button    */
/*	2- The effect = call Take_input 	*/
/* 			 which will take the filename.I */
/*----        ---- - - - - - - - - - - -- - - */
/* 	1- The creation of the SAVE button    */
/*	2- The effect = call Take_input 	*/
/* 			 which will take the filename.I */
/*----------------------------------------------*/



/*----------------------------------------------*/
/* EXTERN for the 1- father widget		*/
/* 	          2- neighbour(s) within the form	*/
/* 		  3- the created widget itself 	*/
/*				ie lload AND ssave */
extern Widget simulation ;
extern Widget title_simulation ;
extern Widget pgmrun; extern Arg pgmrun_arg[];
extern Widget step ;
extern Widget pause; extern Arg pause_arg[];
extern Widget continuous ;
extern Widget lload;
extern Widget ssave;

/* Here Mike was tired and wanted to go back home */
/* therefore at the same place there is callback code + declaration */

/*----------------------------------------------*/
/* CALL BACK OF THE COMMAND "LOAD" AND "SAV" */
/*---------------------------------------------*/
/* LLOAD-CALLBACK() = */

  void Lload_callback(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  /* used as thepopup but no interest at the moment*/
  caddr_t call_data;     /* not used  */
  {
/*	fflush(stdout);*/

	if (!my_algorithm) 
	{ 
		Error(2) ; 
		return ;
	}
        Take_input(initiateur,1) ; 
  }

	static XtCallbackRec Lloadcallback[] = {
		{Lload_callback, NULL},
		{NULL,NULL},
	};

/*---------------------------------------------*/
/* SSAVE_CALLBACK()  */

  void Ssave_callback(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  /* used as thepopup but no interest at the moment*/
  caddr_t call_data;     /* not used  */
  {
/* If a simulation has been running and is now suspended then save the NN */
	if (overallstatus == 'S' )
 	Take_input(initiateur,6) ; 
	else Error(11) ;
  }

static XtCallbackRec Ssavecallback[] = {
		{Ssave_callback, NULL},
		{NULL,NULL},
	};


/*-----------------------------------------------------*/
/* ARGUMENTS FOR lload AND ssave widgets		*/
/*               TOP_CONTROL (shell menupopup)		*/
/*-----------------------------------------------------*/

/* Args for lload widget */
	Arg lload_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNcallback, (XtArgVal)Lloadcallback},
                {XtNhighlightThickness, (XtArgVal)3},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
                {XtNhorizDistance, (XtArgVal)4},
                {XtNvertDistance, (XtArgVal)2},
                {XtNwidth, (XtArgVal)BUTTON_WIDTH},
                {XtNheight, (XtArgVal)BUTTON_HEIGHT},
		{XtNsensitive, (XtArgVal)False},
        };

/* Args for ssave widget */
        Arg ssave_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNcallback, (XtArgVal)Ssavecallback},
                {XtNhighlightThickness, (XtArgVal)3},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
                {XtNhorizDistance, (XtArgVal)4},
                {XtNvertDistance, (XtArgVal)2},
                {XtNwidth, (XtArgVal)BUTTON_WIDTH},
                {XtNheight, (XtArgVal)BUTTON_HEIGHT},
                {XtNsensitive, (XtArgVal)False},

        };
/*-----------------------------------------------------*/
/* CREATION OF THE LLOAD WIDGET				*/
/*-----------------------------------------------------*/
  void Lload()
  {


/* BTN1UP = DEFAULT + RESET otherwise does not unhighlight */
/* Declaration of the translation table for init */
  static String menu_trans = "<Btn1Up>: notify() unset() reset()" ;
  XtTranslations menu_compiled ;

 XtSetArg(lload_arg[0],XtNfromVert, title_simulation) ;
if (!my_application)
 XtSetArg(lload_arg[1],XtNfromHoriz, pgmrun) ;
else
 XtSetArg(lload_arg[1],XtNfromHoriz, step) ;

        lload = XtCreateManagedWidget(" Load ",
                                commandWidgetClass,
                                simulation,
                                lload_arg,
                                XtNumber(lload_arg));

/* Compilation of the translation table for IO */
  menu_compiled = XtParseTranslationTable(menu_trans) ;
  XtOverrideTranslations(lload, menu_compiled) ;


/* "Compile" the call back */
XtAddCallback(lload, XtNcallback,
        Lload_callback,(caddr_t)lload) ;
/* quite useless to pass input_output */

} 
/*-----------------------------------------------------*/
/* CREATION OF THE SAVE WIDGET 				*/
/*-----------------------------------------------------*/
  void Ssave()
  {


/* BTN1UP = DEFAULT + RESET otherwise does not unhighlight */
/* Declaration of the translation table for init */
  static String menu_trans = "<Btn1Up>: notify() unset() reset()" ;
  XtTranslations menu_compiled ;

 XtSetArg(ssave_arg[0],XtNfromVert, lload) ;
if (!my_application)
 XtSetArg(ssave_arg[1],XtNfromHoriz, pause) ;
else
 XtSetArg(ssave_arg[1],XtNfromHoriz, continuous) ;

        ssave = XtCreateManagedWidget(" Save ",
                                commandWidgetClass,
                                simulation,
                                ssave_arg,
                                XtNumber(ssave_arg));

/* Compilation of the translation table for IO */
  menu_compiled = XtParseTranslationTable(menu_trans) ;
  XtOverrideTranslations(ssave, menu_compiled) ;


/* "Compile" the call back */
XtAddCallback(ssave, XtNcallback,
        Ssave_callback,(caddr_t)ssave) ;
/* quite useless to pass input_output */

 }
