/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * LevelParamCreate.c
 ******************************************************************************/

#include "everything.h"
#include "mymonitor.h"
#include "rpcheader.h"

/* Thursday 26 October try Param RPC */
#define rpc_free(x, p) if(p)xdr_free(x, p)

extern char server[];
extern CLIENT *myclient;



/*--------------------------------------------*/
/*  PARAM_CREATE PROC 				*/
/*   creates :                                  */
/*            the param display area (level_param)	*/
/*         	param widget (param[i]), command widget  */
/*			1- on the level displayed 	*/
/*			2- on the NN algorithm          */

/* to give a visual idea of the widget hierarchy here. */
/*    Widget  godfather (level_monitor) */
		/* godbrother (level_display)  */
		/* level_param */
			/* the param command widgets */	


/*----------------------------------------------------*/
/* This proc. creates
 *	1- the level_param, form widget 
 * 		which will include all the param text and value, label
 *		created within <Level-param>_create()
 */

void Param_create(theway, theparent, thebrother, onetocreate)
int theway[] ;
Widget theparent ; /* godfather ie level_monitor */
Widget thebrother;  /* thebrother is level_display */
Widget onetocreate ;  /* onetocreate is level_param */
{

/* Declaration for RPC call */
  strctname rpcpara;
  int   i;
  static rec *param_result ;

  int num ;
  char *firstname ;
/*----------------------------------------------------*/
/* Args for level_param widget */
        static Arg levelparam_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
/* MIKE CHANGE */
                {XtNdestroyCallback, (XtArgVal)NULL},
        /* LATER {XtNborderWidth, (XtArgVal)0}, */
        };


XtSetArg(levelparam_arg[0],XtNfromVert, thebrother ) ;

          onetocreate  = XtCreateManagedWidget("NEW INFO GRAPHIC",
                                formWidgetClass,
                                theparent,
                                levelparam_arg,
                                XtNumber(levelparam_arg));


/* CALL the RPC to get param information */
 rpcpara.indx[0] = 0;
 for (i=0; i<4; i++)
    rpcpara.indx[i+1] = theway[i];
 rpcpara.indx[5] = -1;
 rpcpara.namecode = N_PARA ;

 rpc_free(xdr_rec, param_result);


 param_result = rnetstat_1(&rpcpara, myclient);

 if (!param_result) {
    clnt_perror(myclient, server);
    return;
 }
/* the RPC has not return what we asked for */
 if (param_result->errorn == -1) {
    Error(206) ;
    return; 
 }
/* the RPC failed */
 if (param_result->errorn != 1) 
    {
    Error(206) ;
   return; 
    }
  
  num = param_result->rec_u.dontkno.iarray_len ;
 
if (GiveLevel(theway) == 1) 
 {
  firstname = param_result->rec_u.dontkno.iarray_val[0].name ;
 } ; 


/* According to the level call the procedures which creates the */
/* set of couples param_text and param value */
 switch (GiveLevel(theway))
	{
	case 0 : 
    System_param(onetocreate, &param_result->rec_u.dontkno) ;
		  break ;
	case 1 : 
  Net_param(onetocreate,theway, &param_result->rec_u.dontkno) ;
		  break ;
	case 2 : 
 Layer_param(onetocreate, theway, &param_result->rec_u.dontkno) ;
		  break ;
	case 3 : 
Cluster_param(onetocreate, theway, &param_result->rec_u.dontkno) ;
		  break ;
	case 4 : 
Neuron_param(onetocreate, theway, &param_result->rec_u.dontkno) ;
		  break ;
	} ; 
 
return ;
}
