/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * LevelMonitorCreate.c
 ******************************************************************************/

#include "everything.h"
#include "mymonitor.h"
#include "mike_display.h"

/* Declaration of the structure to pass as a param */
/* for Menu_call and then for Close only           */
typedef struct {
              int pathway[4] ;
              Widget thebigone ;
              Widget themenu ;
               } ReallyForClose ;

typedef struct {
              int way[4] ;
              Widget thebig ;
               } ForCloseCallback ;
 
/* --------------------------------------------------*/
/*  THIS PROC (Monitor_create) CREATES A PYGMALION      */
/*   MONITOR WINDOW AT ANY SCALE 		     */
/* MONITOR_CREATE(TRACK) PROC FROM THE START BUTTON   */
/*      AND FROM NEWSCALE 				*/
/*  SEE AT THE END OF THE FILE FOR MORE EXPLANATION */
/* --------------------------------------------------*/

/* -----------------------------------------------------*/
/* EXTERN for the root widget 				*/
/* -----------------------------------------------------*/
extern Widget overall ;
/* Args for top_control menu widget */
Arg opentopcontrol_arg[] = {
                {XtNx, (XtArgVal)0},
                {XtNy, (XtArgVal)0},
		{XtNborderWidth, (XtArgVal) 4},
        };


/*----------------------------------------------*/
/* CALL BACK OF THE COMMAND OPEN and CLOSE      */

/*---------------------------------------------*/
/* OPEN_CALLBACK() = OPEN			*/
  void Open_Choice_callback(initiateur, client_data, call_data)
  Widget initiateur;
  Widget client_data;  /* used as thepopup */
  caddr_t call_data;     /* not used  */
  {
    Newscale(client_data) ; /* this is top_control */
  } 

/*---------------------------------------------*/
/* CLOSE_CALLBACK() = OPEN			*/
  void Close_Choice_callback(initiateur, client_data, call_data)
  Widget initiateur;
  ReallyForClose  *client_data;  
           /* used as path, Pop graphic and top_control*/
  caddr_t call_data;     /* not used  */
  {
   CloseFamily(client_data->pathway)   ; 
   CloseParamFamily(client_data->pathway)   ; 
   CloseAssocFamily(client_data->pathway)   ; 
/*    XtPopdown(client_data->thebigone) ; 
    XtPopdown(client_data->themenu) ; 
*/
XtUnmapWidget(client_data->thebigone) ;
XtUnmapWidget(client_data->themenu) ;

  } 
 
/* --------------------------------------------------*/
/* NEW ACTION (Xtpopdown) FOR LEAVE WINDOW FOR NEWSCALE MENU   */
/* --------------------------------------------------*/
/*
 *  Mypopdown 
 */
static void Mypopdown(thewidget,event,params,num_params)
Widget thewidget;
XEvent *event ;
String *params ;
Cardinal *num_params ;
{
/*  XtPopdown(thewidget) ;   */
   XtUnmapWidget(thewidget) ;
} 


/*------------------------------------------------*/
/* CALLBACK PROC OF THE TITLE_LEVEL WIDGET   */
/*      	  son of level_monitor	  */
/*      	    son of pop_graphic	  */
/*      	      SON OF OVERALL */
/* --------------------------------------------------*/
/* open  (WILL CALL AGAIN MONITOR_CREATE)
 close */
  void Menu_call(thecaller, client_data, call_data)
  Widget thecaller ;  
  ForCloseCallback  *client_data ; /* used as the path and */
				  /* the POP_GRAPHIC widget */
  caddr_t call_data ;   /* unused */
  {
  Widget opentop_control ,
           control ,
	    open , close ;


  ReallyForClose *really_give_close ;
  int i ;

/*  ADD NEW ACTION : LEAVE WINDOW IMPLIES POPDOWN FOR NEWSCALE MENU   */
/* Declaration of the new translation table */
  static String trans_mymenu = "<LeaveWindow>: my_popdown()" ;
  XtTranslations compiled_mymenu ;
  static XtActionList myaction[] = { {"my_popdown" , Mypopdown} } ;

/* ENTER ANY COMMAND WINDOW = HIGHLIGHT */
  static String command_trans = "<EnterWindow>: set()" ;
  XtTranslations command_compiled ;

/* Declaration of the new cursor */
 Cursor thecursor ; Display *thedisplay ; Window thewindow ;

/*  Position *relativeX , *relativeY ;
  Position theX ,theY ;
*/
Window junk_win;
int x_root, y_root,garbage;
unsigned int garbage_mask;
extern Arg opentopcontrol_arg[3];
/* Arguments for the children of the Form*/
/* Args for any command widget */
        static Arg anycommand_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal)2},
                {XtNdestroyCallback, (XtArgVal)NULL},
                {XtNwidth, (XtArgVal)OPEN_MENU_WIDTH},
		{XtNborderWidth, (XtArgVal) 0},
                } ;

        static Arg control_arg[] = {
/* MIKE CHANGE */
                {XtNdestroyCallback, (XtArgVal)NULL},
                } ;


/*  relativeX = 0 ;
  relativeY = 0 ;
 XtTranslateCoords(thecaller , relativeX , relativeY , &theX , &theY ) ;

  theX = theX + (MONITOR_WIDTH - 300)  ;
 XtSetArg(topcontrol_arg[0],XtNx, theX) ; 
 XtSetArg(topcontrol_arg[1],XtNy, theY) ; 
*/
        opentop_control = XtCreatePopupShell("Open Menu",
                                overrideShellWidgetClass,
                                thecaller,
                                opentopcontrol_arg,
                                XtNumber(opentopcontrol_arg));

             control = XtCreateManagedWidget("OPEN",
                                formWidgetClass,
                                opentop_control,
                                control_arg,
                                XtNumber(control_arg) );

 XtSetArg(anycommand_arg[0],XtNfromVert, NULL ) ;
 XtSetArg(anycommand_arg[1],XtNfromHoriz, NULL) ;
               open = XtCreateManagedWidget(" Open",
                                commandWidgetClass,
                                control,
                                anycommand_arg,
                                XtNumber(anycommand_arg) );
XtAddCallback(open, XtNcallback,
                Open_Choice_callback, (caddr_t)opentop_control) ;


 XtSetArg(anycommand_arg[0],XtNfromVert, open) ;
 XtSetArg(anycommand_arg[1],XtNfromHoriz, NULL) ;

                close= XtCreateManagedWidget(" Close",
                                commandWidgetClass,
                                control,
                                anycommand_arg,
                                XtNumber(anycommand_arg) );

/* Set  the argument to pass to the following callback */
/* 1- int[4] thepath */
/* 2- Widget thebigone => pop_graphic */
/* 3- Widget themenu => top_control */

  really_give_close= (ReallyForClose *) 
          calloc(sizeof(ReallyForClose), 1) ;

  for ( i = 0 ; i < 4 ; i++)
     {
      really_give_close->pathway[i] = client_data->way[i] ;
      } ;
  really_give_close->thebigone = client_data->thebig ;
  really_give_close->themenu = opentop_control ;

  XtAddCallback(close, XtNcallback,
	Close_Choice_callback, (caddr_t)really_give_close);	
   
/*   REALIZE */
/*   XtPopup(top_control, XtGrabExclusive) ;*/
XtRealizeWidget(opentop_control);
XQueryPointer(XtDisplay(opentop_control), XtWindow(opentop_control), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
XtSetArg(opentopcontrol_arg[0],XtNx, x_root-20) ;
XtSetArg(opentopcontrol_arg[1],XtNy, y_root-20) ;
XtSetValues(opentop_control, opentopcontrol_arg, XtNumber(opentopcontrol_arg));
XtMapWidget(opentop_control);


  XtAddActions(myaction,1) ;
  compiled_mymenu = XtParseTranslationTable(trans_mymenu) ;
  XtOverrideTranslations(opentop_control, compiled_mymenu) ;

  command_compiled = XtParseTranslationTable(command_trans) ;
  XtOverrideTranslations(open, command_compiled) ;
  XtOverrideTranslations(close, command_compiled) ;


/*   CURSOR 						*/
  thedisplay = XtDisplay(control) ;
  thewindow = XtWindow(control) ;
  thecursor = XCreateFontCursor(thedisplay , XC_sb_right_arrow) ;
  XDefineCursor(thedisplay, thewindow , thecursor) ;

} 

/* --------------------------------------------------*/
/* --------------------------------------------------*/
/* Monitor_create(TRACK) PROC FROM THE START BUTTON   */
/* 			AND FROM NEWSCALE.C 	      */
/* --------------------------------------------------*/
/*
 * This proc creates a monitor window associated with a level
 * 		SON OF OVERALL !!
 * it should, now create for each level a named structure  ?????
 */

/* --------------------------------------------------*/
/* Add translations which says that BUTTONPRESSEnter the window */
/*     causes the callback ie popup menu	     */
/* --------------------------------------------------*/
  void Add_mytranslation(concerned) 
  Widget concerned ; /* concerned is the level_title widget */
  {
  static String table_leveltitle = "<ButtonPress>: set() notify() unset() unhighlight()" ; 
  XtTranslations compiled_leveltitle ;

  compiled_leveltitle = XtParseTranslationTable(table_leveltitle) ; 
  XtOverrideTranslations(concerned, compiled_leveltitle) ;

  }

/* --------------------------------------------------*/
/*   		THE PROC			     */
/* --------------------------------------------------*/
  void Monitor_create(path)
  int path[] ; /* used to give the path where : */
		/* path[0] = net      */
		/* path[1] = layer */
		/* path[2] = cluster */
		/* path[3] = neuron */
    {
/* 
 * New Pygmalion graphic, TopShellWidget (pop_graphic)
 *   WHICH NOW SHOULD BE ASSOCIATED WITH THE PATH
 * Overall Monitor area, form widget (level_monitor)
 *   	Title area, command widget (level_title)
 *			which pop a menu for creation of a new level monitor
 * 					and deletion of the current one
 *    	Rules are, form widget (rule_
 *
 * the following is done within another file ie MonitorCreate.c
 *
 *	Graphic Display area,  widget 
 *	Parameter area, form widget 
 */
	
  Widget pop_graphic , 
       		level_monitor,
		   level_title ;

  ForCloseCallback *give_close ;
  int i ;

  char  bypass[120] ;

/*------------------------------------------------------*/
/* ARGUMENTS FOR THE WIDGETS				*/
/*    pop graphic , level monitor , level title         */
/*------------------------------------------------------*/

/* Args for pop_graphic Top shell widget of the new */
/* graphic environment */
  static Arg popgraphic_arg[] = {
                {XtNdestroyCallback, (XtArgVal)NULL},
	} ;

/* Args for level_monitor form widget */
  static Arg levelmonitor_arg[] = {
                {XtNdestroyCallback, (XtArgVal)NULL},
	} ;


  static Arg leveltitle_arg[] = {
	{XtNlabel, (XtArgVal)NULL} , 
	{XtNheight, (XtArgVal)TITLE_HEIGHT},
	{XtNwidth, (XtArgVal)MONITOR_WIDTH},
/* MIKE CHANGE */
                {XtNdestroyCallback, (XtArgVal)NULL},
	} ;

/*-------------------------------------------*/
/* TITLE OF THE MONITOR LEVEL ACCORDING TO THE LEVEL (PATH) */
/*-------------------------------------------*/

/* 01 Feb => labelling changes ; from 1 and not 0 */
switch (GiveLevel(path))
        {
 case 0 : 
  XtSetArg(leveltitle_arg[1],XtNlabel, "SYSTEM LEVEL") ;
  break ;

 case 1 : 
  sprintf(bypass, "NET (%i) " , path[0]+1 ) ; 
  XtSetArg(leveltitle_arg[1],XtNlabel, bypass ) ;
  break ;

 case 2 : 
 sprintf(bypass, "LAYER (%i, %i) " , path[0] +1, path[1]+1 ) ; 
    XtSetArg(leveltitle_arg[1],XtNlabel, bypass) ;
    break ;

 case 3 : 
 sprintf(bypass, "CLUSTER (%i,  %i, %i)" , path[0]+1 , path[1]+1 , path[2] +1) ; 
   XtSetArg(leveltitle_arg[1],XtNlabel, bypass ) ;
   break ;

 case 4 : 
 sprintf(bypass, "NEURON (%i, %i,  %i, %i)",
path[0]+1,path[1]+1,path[2]+1,path[3]+1 ); 

  XtSetArg(leveltitle_arg[1],XtNlabel, bypass ) ;
  break ;
        } ;
 
/*-------------------------------------------*/
/* CREATION OF THE WIDGETS 			*/
/*    pop graphic , level monitor , level title         */
/*-------------------------------------------*/
   pop_graphic = XtCreatePopupShell("PYGMALION GRAPHICS", 
			  shellWidgetClass,
			  overall,
			  popgraphic_arg,
	 		  XtNumber(popgraphic_arg));

   level_monitor = XtCreateManagedWidget("Youpa", 
			  formWidgetClass,
			  pop_graphic,
			  levelmonitor_arg,
	 		  XtNumber(levelmonitor_arg));

       	level_title = XtCreateManagedWidget("Youpa", 
			  commandWidgetClass,
			  level_monitor,
			  leveltitle_arg,
	 		  XtNumber(leveltitle_arg));


/*-------------------------------------------*/
/* 
 * Create the call back with more parameters 
 * in order to destroy the new Graphic widget
 * when opening or closing
 */
/*-------------------------------------------*/
/* Set  the argument to pass to the following callback */
/* 1- int[4] way */
/* 2- Widget thebig => pop_graphic */

   give_close= ( ForCloseCallback *) calloc(sizeof(ForCloseCallback) , 1) ;

  for ( i = 0 ; i < 4 ; i++)
        {
      give_close->way[i] = path[i] ;
       } ;
  give_close->thebig = pop_graphic ;

   XtAddCallback(level_title, XtNcallback,
		Menu_call, (caddr_t)give_close);	


/*-------------------------------------------*/
/* Creation of rule and  display and status area */
/* according to the scale choosen by the user */
/* give also the father as an argument */
/*-------------------------------------------*/


  RuleDisplayParam_create(path, level_monitor, level_title) ;



 
/*-------------------------------------------*/
/* MAPPING ONTO THE SCREEN 		     */
/*-------------------------------------------*/
     XtPopup(pop_graphic, XtGrabNone) ; 

/*-------------------------------------------*/
/* TRY TO ADD THE TRANSLATION TABLE AT THIS POINT AND VIA A PROC */
/* It does not work ie I can change it (as "Enter" no more highlightt) */
/*    but I can not put instead "notify()" ????? */
/* NOW (3pm) it works coze I've put SET before NOTIFY  */
/*-------------------------------------------*/
  Add_mytranslation(level_title) ;

if((DisplayCells(XtDisplay(pop_graphic), DefaultScreen(XtDisplay(pop_graphic)))) > 2)
{
	XSetWindowColormap(XtDisplay(pop_graphic), XtWindow(pop_graphic), pgm_cmap);
}
/* sync is so that window is displayed before the user can 
 * click on the graphic area to get menu - if don't
 * do this you can cause a bus error!
 */
 
 XSync(XtDisplay(pop_graphic), 0); 
}

