/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * InterconnectCreate.c
 ******************************************************************************/

#include "everything.h"
#include "mymonitor.h"
#include "mike_display.h"

/* This file creates, dynamically the interconnect-button-boxes */
/* DYNAMIC at the moment = RPC CALL done in LevelRuleCreate.c */
/* Interconnection = */
/*	 system level => connection between  output net-layer input net-layer */
/*	 net level => connection between layers */
/*	 layer level => connection between  clusters */
/*	 cluster level => connection between  neurons */
 

/* CAUTION */
/* Global HaryPointer to be known by all callbacks */
  InterconnectStructure  *HaryPointer ;
/* global var to know about the labelling */
  Bool normal[4] ; /* normal = true => no changes */
                /* normal = false => changes (-1) to the result */

/*-----------------------------------------------------*/
/* ARGUMENT FOR ANY COMMAND  HELP 1 and 2 + Enter      */
/*-----------------------------------------------------*/

/* Args for any command widget */
	static Arg anycommand_arg[] = {
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNfromVert, (XtArgVal)NULL},
		{XtNlabel, (XtArgVal)NULL},
		{XtNhighlightThickness, (XtArgVal)3},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNhorizDistance, (XtArgVal)3},
		{XtNvertDistance, (XtArgVal)1},
	};

	static Arg help1_arg[] = {
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNfromVert, (XtArgVal)NULL},
		{XtNlabel, (XtArgVal)NULL},
		{XtNhighlightThickness, (XtArgVal)0},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNhorizDistance, (XtArgVal)1},
		{XtNvertDistance, (XtArgVal)1},
	};
	static Arg help2_arg[] = {
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNfromVert, (XtArgVal)NULL},
		{XtNlabel, (XtArgVal)NULL},
		{XtNhighlightThickness, (XtArgVal)0},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNhorizDistance, (XtArgVal)1},
		{XtNvertDistance, (XtArgVal)1},
	};

  static Arg enter_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal)2},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
               } ;

/*-----------------------------------------------------*/
/* CALLBACK FOR NET , LAYER , CLUSTER , NEURON RULES	*/
/*-----------------------------------------------------*/
/* ENTER_CALLBACK() =                           */

  void Ienter_callback(initiateur, client_data, call_data)
  Widget initiateur;
  int client_data;  /* to pass nothing */
  caddr_t call_data;     /* not used  */
  { 
  int element ;
  int i ;
  float *thearray ;

/* Find the level according to path_current and then set the proper */
/* element within path_inter2 */ 
  element = GiveLevel(HaryPointer->path_current) ;

/* Feb 01 => labelling changes */
  switch (element)
	{
	case 0 : /* net element */
		if (!normal[0]) 
			{
			HaryPointer->path_inter1[element] = 
				HaryPointer->path_inter1[element] - 1 ;
			HaryPointer->path_inter2[element] =
				HaryPointer->path_inter2[element] - 1 ;
			}
		break ;
	case 1 : /* layer element */
		if (!normal[0]) 
			HaryPointer->path_inter1[0] = 
				HaryPointer->path_inter1[0] - 1 ;
		if (!normal[1]) 
			{
			HaryPointer->path_inter1[1] = 
				HaryPointer->path_inter1[1] - 1 ;
			HaryPointer->path_inter2[1] = 
				HaryPointer->path_inter2[1] - 1 ;
 			} ;
		break ;
	case 2 : /* cluster element */
		if (!normal[0]) 
			HaryPointer->path_inter1[0] = 
				HaryPointer->path_inter1[0] - 1 ;
		if (!normal[1]) 
			HaryPointer->path_inter1[1] = 
				HaryPointer->path_inter1[1] - 1 ;
		if (!normal[2]) 
			{
			HaryPointer->path_inter1[2] = 
				HaryPointer->path_inter1[2] - 1 ;
			HaryPointer->path_inter2[2] = 
				HaryPointer->path_inter2[2] - 1 ;
			} ;
		break ;
	case 3 : /* neuron element */
		if (!normal[0]) 
			HaryPointer->path_inter1[0] = 
				HaryPointer->path_inter1[0] - 1 ;
		if (!normal[1]) 
			HaryPointer->path_inter1[1] = 
				HaryPointer->path_inter1[1] - 1 ;
		if (!normal[2]) 
			HaryPointer->path_inter1[2] = 
				HaryPointer->path_inter1[2] - 1 ;
		if (!normal[3]) 
			{
			HaryPointer->path_inter1[3] = 
				HaryPointer->path_inter1[3] - 1 ;
			HaryPointer->path_inter2[3] = 
				HaryPointer->path_inter2[3] - 1 ;
			} ;
		break ;
	} ;

/* Check if the two components for connectivity have been choosen */
/* otherwise pop up an error */
  if (HaryPointer->path_inter1[element] == -1 
      || HaryPointer->path_inter2[element] == -1 ) 
    Error(8)   ;
  else 
  {
/* check if the path given is right */
     if(CheckPath(HaryPointer->path_inter1,
        GiveLevel(HaryPointer->path_inter1))) 
      {
       if ( CheckPath(HaryPointer->path_inter2 , 
            GiveLevel(HaryPointer->path_inter2))) 
          {

/* Call to FILL_CONNECT */
   Fill_connect_family(HaryPointer->path_current , HaryPointer->drawing ,
			HaryPointer->path_inter1 , HaryPointer->path_inter2) ;

refresh_window(HaryPointer->drawing  , HaryPointer->path_current ,
 HaryPointer->flag_inter , HaryPointer->path_inter1 ,HaryPointer->path_inter2);

/*        XtPopdown(HaryPointer->kill) ;
        XtPopdown(HaryPointer->hurt) ;  
*/
XtUnmapWidget(HaryPointer->kill);
XtUnmapWidget(HaryPointer->hurt);

        return ;
	  }  ;
       }  ;
/*     XtPopdown(HaryPointer->kill) ;
     XtPopdown(HaryPointer->hurt) ;  
*/
XtUnmapWidget(HaryPointer->kill);
XtUnmapWidget(HaryPointer->hurt);

   } ;
 }

/* FROM NET  */
void First_net_inter(w, client_data, call_data)
Widget w;
int client_data;  /* to pass the counter */
caddr_t call_data;    /* not used */
{
 if (HaryPointer->path_inter1[0] == -1) 
  {
  if (!normal)
   	if (client_data == 0 ) { Error(25) ; return ;}   ;
  HaryPointer->path_inter1[0] =  client_data ;
  } 
 else
  HaryPointer->path_inter1[0] =  HaryPointer->path_inter1[0] *10 
					+ client_data ;
 
}

/* FROM LAYER */
void First_layer_inter(w, client_data, call_data)
Widget w;
int client_data;  /* to pass the counter */
caddr_t call_data;    /* not used */
{
 
 if (HaryPointer->path_inter1[1] == -1) 
  {
  if (!normal)
   	if (client_data == 0 ) { Error(25) ;  return ;};
  HaryPointer->path_inter1[1] =  client_data ;
  } 
 else
  HaryPointer->path_inter1[1] =  HaryPointer->path_inter1[1] *10 
					+ client_data ;
}

/* FROM CLUSTER */
void First_cluster_inter(w, client_data, call_data)
Widget w;
int client_data;  /* to pass the counter */
caddr_t call_data;    /* not used */
{
 
 if (HaryPointer->path_inter1[2] == -1) 
  {
  if (!normal)
   	{
   	if (client_data == 0 ) { Error(25) ; return ;}  
   	} ;
  HaryPointer->path_inter1[2] =  client_data ;
  } 
 else
  HaryPointer->path_inter1[2] =  HaryPointer->path_inter1[2] *10 
					+ client_data ;
}

/* FROM NEURON */
void First_neuron_inter(w, client_data, call_data)
Widget w;
int client_data;  /* to pass the counter */
caddr_t call_data;    /* not used */
{
 if (HaryPointer->path_inter1[3] == -1) 
  {
  if (client_data == 0) Error(25) ;  
  HaryPointer->path_inter1[3] =  client_data ;
  } 
 else
  HaryPointer->path_inter1[3] =  HaryPointer->path_inter1[3] *10 
					+ client_data  ;
}

/* TO NET , LAYER , CLUSTER */
void Second_net_inter(w, client_data, call_data)
Widget w;
int client_data;  /* to pass the counter */
caddr_t call_data;    /* not used */
{
 int element ;
 
/* Find the level according to path_current and then set the proper */
/* element within path_inter2 */ 
  element = GiveLevel(HaryPointer->path_current) ;
 
 if (HaryPointer->path_inter2[element] == -1) 
  {
  if (!normal)
	if (client_data == 0 ) {Error(25) ; return  ; } ;
  HaryPointer->path_inter2[element] =  client_data;
  } 
 else
  HaryPointer->path_inter2[element] =  HaryPointer->path_inter2[element] *10 
					+ client_data ;

}


/*----------------------------------------------------*/
/*----------------------------------------------------*/
/* THE PROCEDURES NET_INTERCONNECT 			*/
/* 		  LAYER_INTERCONNECT 			*/
/* 		  CLUSTER_INTERCONNECT 			*/
/* 		  NEURON_INTERCONNECT 			*/
/*----------------------------------------------------*/
/* Comments it is called like if it was only about net coze */
/*		I am to lazy to change the name !!	    */

/*----------------------------------------------------*/
/* 		NET_INTERCONNECT 		     */
  void NetInterconnect( netpath , family , strange_conf)
  int netpath[] ;
  FamilyWidget family ;
  rpcsys *strange_conf ;
/* where 1- mikeneed is level_display(for MIKE) */
/*       2- firstmenu = this is the Magnify ,Colourmap, Colour, Select Menu */
/*	  3- nowmenu   = this is the topcontrol (topmenu override widget )  */
  {
/* as many button boxes as needed */
  Widget *any_tocommand , *any_fromcommand ; 
  Widget help_one , help_two , help_three , help_four , 
       help_second ;  /* to put the level concerned */
  Widget enter ;

  int counter ;
  int other , i  ;
  int loop_number ;
  int fromloop ;
  int previousfromloop ;
  int fromnumber ;
  int fromcounter;
  int escapepath[4] ;
  String *name_number ;

  static String command_trans = "<LeaveWindow>:unset()\n\
                                 <EnterWindow>:unset()\n\
                                 <Btn1Down>:set()\n\
                                 <Btn1Up>:notify() unset() highlight()" ;

  XtTranslations command_compiled ;

  
/* Allocation fo the memory space 1- for the widgets */
/* 		2- for the pointer to thecall back */ 
/* first = find the loop number */ 
  loop_number = GiveNumber(netpath) ;
  for (i = 0 ; i < 4 ; i++)
      normal[i] = True ;

/* if loop_number > 9 then create only nine buttons  */
/* and allows the user to type number > 10 */
 if (loop_number > 9 ) 
	  loop_number = 10 ;

/* fromnumber is the number of <From name> 0 1 ... loop_number to pop */
/*      0 => system,  1 => net,  2 => layer, 3=> cluster, 4 => neuron  */
 for ( counter = 0 ; counter < 4 ; counter++ ) 
  {
  escapepath[counter] = -1 ;
  } ;
 fromloop = GiveMaxNumber(escapepath) ;
 if (fromloop > 9 ) { fromloop = 10 ; normal[0] = False ; } ;
 previousfromloop = 0 ;
 fromnumber = GiveLevel(netpath) +1 ;
 
  any_tocommand = (Widget *) calloc(sizeof(Widget), loop_number);
/* maximum allocation */
  any_fromcommand = (Widget *) calloc(sizeof(Widget), 
			fromnumber * 10);
  
  HaryPointer= (InterconnectStructure *) 
		calloc(sizeof(InterconnectStructure), 1);

  name_number  = (String *) calloc(sizeof(String) , 20) ;


/* Init HaryPointer */
/* initialise path for the call back */
 for ( counter = 0 ; counter < 4 ; counter++ ) 
  {
  HaryPointer->path_current[counter] = netpath[counter] ;
  HaryPointer->path_inter1[counter] = -1 ;
  HaryPointer->path_inter2[counter] = netpath[counter] ;
  } ;
 HaryPointer->flag_inter = True ;
 HaryPointer->drawing = family.mikeneed  ;
 HaryPointer->kill = family.firstmenu   ;
 HaryPointer->hurt = family.nowmenu  ;
 HaryPointer->low_colour = 'n' ;
 HaryPointer->high_colour = 'n' ;


/* for all command widget Vert = NULL */
  XtSetArg(anycommand_arg[1],XtNfromVert, NULL) ; 

/* according to the level (system , net , layer or cluster ) */
/* 1- set the end of the FOR loop */
/* 2- set the title of the help widget */

 switch (GiveLevel(netpath))
  {
/* system level => net interconnection */
 case 0 :
      XtSetArg(help2_arg[2],XtNlabel, "To Net   " ) ;
         break ;
/* net level => layer interconnection */
 case 1 :
      XtSetArg(help2_arg[2],XtNlabel, "To Layer   " );
         break ;
/* layer level => cluster interconnection */
 case 2 :
      XtSetArg(help2_arg[2],XtNlabel, "To Cluster   " ) ;
         break ;
/* cluster level => neuron  interconnection */
 case 3 :
      XtSetArg(help2_arg[2],XtNlabel, "To Neuron   " ) ;
         break ;
  } ;

/* Add the translations to every command number widget */
  command_compiled = XtParseTranslationTable(command_trans) ;

fromcounter = 0 ;
while (fromcounter < fromnumber)
 {

/* create the title associated with number command widgets */
   XtSetArg(help1_arg[0],XtNfromHoriz, NULL) ;
switch (fromcounter) {
   case 0 : 
      XtSetArg(help1_arg[1],XtNfromVert, NULL) ;
      XtSetArg(help1_arg[2],XtNlabel, "From Net " ) ;
      help_one  = XtCreateManagedWidget( "rubbish" ,
				commandWidgetClass,
				family.nowform ,
				help1_arg,
				XtNumber(help1_arg));
      break ;
   case 1 : 
      XtSetArg(help1_arg[1],XtNfromVert, help_one) ;
      XtSetArg(help1_arg[2],XtNlabel, "From Layer " ) ;
      help_two  = XtCreateManagedWidget( "rubbish" ,
				commandWidgetClass,
				family.nowform ,
				help1_arg,
				XtNumber(help1_arg));
      break ;
   case 2 : 
      XtSetArg(help1_arg[1],XtNfromVert, help_two) ;
      XtSetArg(help1_arg[2],XtNlabel, "From Cluster " ) ;
      help_three  = XtCreateManagedWidget( "rubbish" ,
				commandWidgetClass,
				family.nowform ,
				help1_arg,
				XtNumber(help1_arg));
      break ;
   case 3 : 
      XtSetArg(help1_arg[1],XtNfromVert, help_three ) ;
      XtSetArg(help1_arg[2],XtNlabel, "From Neuron " ) ;
      help_four  = XtCreateManagedWidget( "rubbish" ,
				commandWidgetClass,
				family.nowform ,
				help1_arg,
				XtNumber(help1_arg));
      break ;

	   }  ;
/* end of the case */


/* Creation of the button rules widget + callback and arg */
/* for the first element of interconnection */
  for (counter = 0 ; counter < fromloop; counter++ )
      {

/* position correctly the command widgets */
	 if (fromcounter == 0 )
          XtSetArg(anycommand_arg[1],XtNfromVert,NULL) ; 
	 if (fromcounter == 1 )
          XtSetArg(anycommand_arg[1],XtNfromVert,help_one) ; 
	 if (fromcounter == 2 )
          XtSetArg(anycommand_arg[1],XtNfromVert,help_two) ; 
	 if (fromcounter == 3 )
          XtSetArg(anycommand_arg[1],XtNfromVert,help_three) ; 

	if (counter >= 1 ) 
          XtSetArg(anycommand_arg[0],XtNfromHoriz, 
		any_fromcommand[counter-1 +previousfromloop]) ; 
	else 
         {
	 if (fromcounter == 0 )
           XtSetArg(anycommand_arg[0],XtNfromHoriz, help_one) ; 
	 if (fromcounter == 1 )
           XtSetArg(anycommand_arg[0],XtNfromHoriz, help_two) ; 
	 if (fromcounter == 2 )
           XtSetArg(anycommand_arg[0],XtNfromHoriz, help_three) ; 
	 if (fromcounter == 3 )
           XtSetArg(anycommand_arg[0],XtNfromHoriz, help_four) ; 
         } ;

/* Feb 01 => labelling changes */
/* assign the label */
  if (fromcounter != 3 )
 	{
 	if (normal[fromcounter])
          {
	  sprintf(name_number , " %i " , counter+1) ;
          XtSetArg(anycommand_arg[2],XtNlabel, name_number ) ;
          }
	else
          {
	  sprintf(name_number , " %i " , counter) ;
          XtSetArg(anycommand_arg[2],XtNlabel, name_number ) ;
          }

 	}
/* neuron level => tricky labelling */
/* labelling goes from 0 to 9 */
  else  {
        sprintf(name_number , " %i " , counter) ;
        XtSetArg(anycommand_arg[2],XtNlabel, name_number ) ;
 	}
        
/* create the number command widgets */
      any_fromcommand[counter + previousfromloop] 
		= XtCreateManagedWidget( "" ,
				commandWidgetClass,
				family.nowform ,
				anycommand_arg,
				XtNumber(anycommand_arg));

  XtOverrideTranslations(any_fromcommand[counter +previousfromloop], 
		command_compiled) ;

/* create the corresponding callbacks */
switch (fromcounter) {
  case 0 : XtAddCallback(any_fromcommand[counter +previousfromloop], 
		XtNcallback, First_net_inter, (caddr_t)counter) ;
	   break ;
  case 1 : XtAddCallback(any_fromcommand[counter +previousfromloop], 
		XtNcallback, First_layer_inter, (caddr_t)counter) ;
	   break ;
  case 2 : XtAddCallback(any_fromcommand[counter +previousfromloop], 
		XtNcallback, First_cluster_inter, (caddr_t)counter) ;
	   break ;
  case 3 : XtAddCallback(any_fromcommand[counter +previousfromloop], 
		XtNcallback, First_neuron_inter, (caddr_t)counter) ;
	   break ;
	   }  ;
/* end of the case */

	}  ;
/* end of the for loop */

/* assign the new from loop according to max number */
switch (fromcounter) {
   case 0 : 
/* next step => net level => max nbe of layers */
      escapepath[0] = 0 ; 
      previousfromloop = fromloop  ;
      fromloop = GiveMaxNumber(escapepath) ;
      if (fromloop > 9 ) { fromloop = 10  ; normal[1] = False ; } ;
      break ;
   case 1 : 
/* next step => layer level => max nbe of clusters */
      escapepath[1] = 0 ;
      previousfromloop = fromloop  ;
      fromloop = GiveMaxNumber(escapepath) ;
      if (fromloop > 9 ) {fromloop = 10 ; normal[2] = False ; } ;
      break ;
   case 2 : 
/* next step => cluster level => max nbe of neurons */
      escapepath[2] = 0 ;
      previousfromloop = fromloop  ;
      fromloop = 10 ; /* always more than 10 neurons */
      normal[3] = False ;
      break ;
	   }  ;
/* end of the case */


fromcounter++ ;
 }
/* end of while */


/* Create the title second widget */
   XtSetArg(help2_arg[0],XtNfromHoriz, NULL) ; 
  if (fromnumber-1 == 0)
   XtSetArg(help2_arg[1],XtNfromVert, help_one) ;
  if (fromnumber-1 == 1)
   XtSetArg(help2_arg[1],XtNfromVert, help_two) ;
  if (fromnumber-1 == 2)
   XtSetArg(help2_arg[1],XtNfromVert, help_three) ;
  if (fromnumber-1 == 3)
   XtSetArg(help2_arg[1],XtNfromVert, help_four) ;

      help_second = XtCreateManagedWidget( "rubbish" ,
				commandWidgetClass,
				family.nowform ,
				help2_arg,
				XtNumber(help2_arg));


/* for the second element of interconnection */
  for (counter = 0 ; 
		counter < loop_number ; counter++ )
      {

/* for every command the Vert distance is compare to their equivalent */
  if (fromnumber-1 == 0)
      XtSetArg(anycommand_arg[1],XtNfromVert, help_one) ; 
  if (fromnumber-1 == 1)
      XtSetArg(anycommand_arg[1],XtNfromVert, help_two) ; 
  if (fromnumber-1 == 2)
      XtSetArg(anycommand_arg[1],XtNfromVert, help_three) ; 
  if (fromnumber-1 == 3)
      XtSetArg(anycommand_arg[1],XtNfromVert, help_four) ; 

	if (counter > 0) 
        XtSetArg(anycommand_arg[0],XtNfromHoriz, any_tocommand[counter-1]) ; 
	else 
         {
         XtSetArg(anycommand_arg[0],XtNfromHoriz, help_second) ; 
         } ; 

/* Feb 01 => labelling changes */
/* assign the name */
  if (fromnumber-1 != 3)
 	{
	if (normal[fromnumber-1])
	  {
          sprintf(name_number , " %i " , counter+1) ;
          XtSetArg(anycommand_arg[2],XtNlabel, name_number ) ;
	  } 
	else 
	  {
          sprintf(name_number , " %i " , counter) ;
          XtSetArg(anycommand_arg[2],XtNlabel, name_number ) ;
	  } 
 	}
/* neuron level => tricky labelling */
/* labelling goes from 0 to 9 */
  else  {
        sprintf(name_number , " %i " , counter) ;
        XtSetArg(anycommand_arg[2],XtNlabel, name_number ) ;
 	}
        

/* create the command number widgets */
      any_tocommand[counter] = XtCreateManagedWidget( "" ,
				commandWidgetClass,
				family.nowform ,
				anycommand_arg,
				XtNumber(anycommand_arg));

	XtAddCallback(any_tocommand[counter], XtNcallback,
                Second_net_inter, (caddr_t)counter ) ;

	}  ;


/* Create the ENTER button */
    XtSetArg(enter_arg[1],XtNfromHoriz, NULL) ;
    XtSetArg(enter_arg[0],XtNfromVert, help_second) ;
     enter = XtCreateManagedWidget("ENTER",
                                commandWidgetClass,
				family.nowform ,
                                enter_arg,
                                XtNumber(enter_arg) );
     XtAddCallback(enter , XtNcallback,
                Ienter_callback, (caddr_t)counter) ;


/* Overwrite the trans table for all command widget */
  for (counter = 0 ; counter < loop_number ; counter++)
   {
  XtOverrideTranslations(any_tocommand[counter], command_compiled) ;
   } ;
}

