/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * Init_control.c
 ******************************************************************************/

#include "everything.h"
#include "myheader.h"

/*----------------------------------------------*/
/* THIS PROC DEALS WITH                         */
/*      1- The creation of the INIT button     */
/*      2- The callback = menu (Weights , States , File) */
/*          More callback = 2.1=> weights from file  */
/*      		    2.2=> states from file */
/*      		    2.3=> weights and states from file */
/*----------------------------------------------*/
/* PROBLEM = TOMPOINTER HAS TO BE A **POINTER IN ORDER FOR THE */
/* FIELD VALUE TO BE DIFFERENT !!    */

/*----------------------------------------------*/
/* EXTERN for the 1- father widget		*/
/* 	          2- neighbour(s) within the form	*/
/* 		  3- the created widget itself 	*/
/*				INIT           */
extern Widget simulation ;
extern Widget title_simulation ;
extern Widget lload;
extern Widget init;
/* Args for top_control menu widget */
Arg choicetopcontrol_arg[] = {
                {XtNx, (XtArgVal)0},
                {XtNy, (XtArgVal)0},
        };

/*----------------------------------------------*/
/* ANOTHER NICE STRUCTURE TO GIVE AS CALLBACK ARG */
 typedef struct { 
              Widget  first ;
              Widget second ;
              int value ;
                } AnotherNice ;
 
        
/*-----------------------------------------------------------*/
/* ACTION MYPOPDOWNINIT() = Popdown the (0 weight , 1 weight ...) menu */
/*                              alias init_control            */
/*-----------------------------------------------------------*/
void MypopdownInit(thewidget, event, params ,num_params)
Widget thewidget;
XEvent *event ;
String *params ;
Cardinal *num_params ;
{
/* XtPopdown(thewidget) ;*/
XtUnmapWidget(thewidget);
}
/* To avoid poping it down after selection of States, Weights or File */
void Mynull(thewidget, event, params ,num_params)
Widget thewidget;
XEvent *event ;
String *params ;
Cardinal *num_params ;
{
}
/*----------------------------------------------*/
/* CALL BACK OF THE COMMAND INIT WEIGHT  	*/
/*			    INIT STATES		*/
/*			    INIT THROUGH FILE	*/
/*---------------------------------------------*/
/* WEIGHT_CALLBACK() = WEIGHT CALL BACK               */

  void Weight_Loading_callback(initiateur, client_data, call_data)
  Widget initiateur;
  Widget client_data;  /* used as thepopup */
  caddr_t call_data;     /* not used  */
  {

/* First => pop down all the menus */
/*        XtPopdown(client_data) ;*/
XtUnmapWidget(client_data);

/* pop up message */
  	Error(0) ;

/*	load_weight = client_data->value ;
 *        if ( (load_weight == 1 || load_weight == 2) 
 *          && (load_state == 1 || load_state == 2)
 *           )
 *           Add_information(2,"DONE BY USER") ;
 */
  } 

/*---------------------------------------------*/
/* STATE () = STATE CALL BACK               */

  void State_Loading_callback(initiateur, client_data, call_data)
  Widget initiateur;
  Widget client_data;  /* used as thepopup */
  caddr_t call_data;     /* not used  */
  {
/* First => pop down all the menus */
/*        XtPopdown(client_data) ;*/
XtUnmapWidget(client_data);

/* pop up message */
  	Error(0) ;

/* load_state = client_data->value ;
 *        if ( (load_weight == 1 || load_weight == 2) 
 *          && (load_state == 1 || load_state == 2)
 *           )
 *           Add_information(2,"DONE BY USER") ;
 */
  } 
	
/*---------------------------------------------*/
/* FILE () = FILE CALL BACK               */

  void File_Loading_callback(initiateur, client_data, call_data)
  Widget initiateur;
  Widget client_data;  /* used as the menu (States, Weights, File)*/
  caddr_t call_data;     /* not used  */
  {
/*   XtPopdown(client_data) ;*/
XtUnmapWidget(client_data);

/* pop up message */
  	Error(0) ;

/* If it was the default then user overwrite */
/*    if (!load_weight && !load_state)
 *	  Take_input(initiateur,5) ; 
 *    else 
 *	 Error(3) ;
 */
}

/*----------------------------------------------
 * CREATION OF THE FIRST MENU FOR INIT 		 
 * MAIN FUNCTION = pop up of a menu to decide between 
 *			States or Weights init
/*----------------------------------------------*/
  void Choice_Init_callback(thecaller, client_data, call_data)
  Widget thecaller ;
  Widget client_data ; /* init widget (same as thecaller => useless) */
  caddr_t call_data ;

  {
  Widget  choice_top_control ,
            choice_control ,
             choice_weight , choice_state , choice_file ;

/* LEAVE WINDOW = POP (STATES, WEIGHTS, FILE) MENU DOWN */
  static String menu_trans = "<LeaveWindow>:  mypopdowninit()" ;
  XtTranslations menu_compiled ;
  static XtActionList mymenupopdown[]={{"mypopdowninit",MypopdownInit}} ;
extern Arg choicetopcontrol_Arg[2];
Window junk_win;
int x_root, y_root,garbage;
unsigned int garbage_mask;

  
/* ENTER STATES OR WEIGHTS OR FILE CHILDREN WIDGETS = HIGHLIGHT */
  static String command_trans = "<EnterWindow>: set()" ;
  XtTranslations command_compiled ;

/* Change the cursor */
  Cursor thecursor ; Display *thedisplay ; Window thewindow ;

/*  Position *relativeX , *relativeY ;
  Position theX ,theY ;
*/
/* Arguments for the children of the Form*/
/* Args for any command widget */
        static Arg anycommand_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal)2},
                {XtNdestroyCallback, (XtArgVal)NULL},
                {XtNwidth, (XtArgVal)INIT_MENU_WIDTH +INIT_MENU_WIDTH/2},
                } ;
 

/* obligation for the control widget not to have a NULL size */
        static Arg choicecontrol_arg[] = {
/* MIKE CHANGE */
                {XtNdestroyCallback, (XtArgVal)NULL},
                } ;


/*  relativeX = 0 ;
  relativeY = 0 ;
 XtTranslateCoords(thecaller , relativeX , relativeY , &theX , &theY ) ;

theX = theX + (BUTTON_WIDTH - 8) ;
theY = theY + (BUTTON_HEIGHT - 6) ;

 XtSetArg(choicetopcontrol_arg[0],XtNx, theX) ;
 XtSetArg(choicetopcontrol_arg[1],XtNy, theY) ;
*/
        choice_top_control = XtCreatePopupShell("IOMenu",
                                overrideShellWidgetClass,
                                thecaller,
                                choicetopcontrol_arg,
                                XtNumber(choicetopcontrol_arg));

       choice_control = XtCreateManagedWidget("INIT MENU",
                                formWidgetClass,
                                choice_top_control,
                                choicecontrol_arg,
                                XtNumber(choicecontrol_arg));

 XtSetArg(anycommand_arg[0],XtNfromVert, NULL ) ;
 XtSetArg(anycommand_arg[1],XtNfromHoriz, NULL) ;
          choice_weight = 
	      XtCreateManagedWidget("Init Weights from file (default = rand)",
                                commandWidgetClass,
                                choice_control,
                                anycommand_arg,
                                XtNumber(anycommand_arg) );
XtAddCallback(choice_weight, XtNcallback,
               Weight_Loading_callback , (caddr_t)choice_top_control) ;


 XtSetArg(anycommand_arg[0],XtNfromVert, choice_weight) ;
 XtSetArg(anycommand_arg[1],XtNfromHoriz, NULL) ;
               choice_state = 
 	          XtCreateManagedWidget("Init States from file (default = 0)",
                                commandWidgetClass,
                                choice_control,
                                anycommand_arg,
                                XtNumber(anycommand_arg) );
XtAddCallback(choice_state, XtNcallback,
               State_Loading_callback , (caddr_t)choice_top_control) ;

 XtSetArg(anycommand_arg[0],XtNfromVert, choice_state) ;
 XtSetArg(anycommand_arg[1],XtNfromHoriz, NULL) ;
               choice_file = 
	             XtCreateManagedWidget(" Weights and States from file",
                                commandWidgetClass,
                                choice_control,
                                anycommand_arg,
                                XtNumber(anycommand_arg) );
XtAddCallback(choice_file, XtNcallback,
                File_Loading_callback, (caddr_t)choice_top_control) ;

/* translation table to leave = pop down */
  XtAddActions(mymenupopdown,1) ;
  menu_compiled = XtParseTranslationTable(menu_trans) ;
  XtOverrideTranslations(choice_top_control, menu_compiled) ;

  command_compiled = XtParseTranslationTable(command_trans) ;
  XtOverrideTranslations(choice_weight, command_compiled) ;
  XtOverrideTranslations(choice_state, command_compiled) ;
  XtOverrideTranslations(choice_file, command_compiled) ;


/* REALIZE  */
/*  XtPopup(choice_top_control, XtGrabNone) ;*/
XtRealizeWidget(choice_top_control);
XQueryPointer(XtDisplay(choice_top_control), XtWindow(choice_top_control), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
XtSetArg(choicetopcontrol_arg[0],XtNx, x_root-20) ;
XtSetArg(choicetopcontrol_arg[1],XtNy, y_root-20) ;
XtSetValues(choice_top_control, choicetopcontrol_arg, XtNumber(choicetopcontrol_arg));
XtMapWidget(choice_top_control);


/* Change the cursor ; becomes an arrow */
  thedisplay = XtDisplay(choice_control) ;
  thewindow = XtWindow(choice_control) ;
  thecursor = XCreateFontCursor(thedisplay , XC_sb_right_arrow) ;
  XDefineCursor(thedisplay, thewindow , thecursor) ;

}

/*----------------------------------------------
 * CREATION OF THE INIT command widget (proc name= Init)
 * MAIN FUNCTION = Button Press causes the pop up of a menu 
/*----------------------------------------------*/

/*-----------------------------------------------------*/
/* ARGUMENTS FOR INIT widget				*/
/*-----------------------------------------------------*/

/* Args for init widget */
  static Arg init_arg[] = {
                {XtNcallback, (XtArgVal)NULL},
                {XtNhighlightThickness, (XtArgVal)3},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
                {XtNfromVert, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)2},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNhorizDistance, (XtArgVal)4},
                {XtNwidth, (XtArgVal)BUTTON_WIDTH},
                {XtNheight, (XtArgVal)BUTTON_HEIGHT},
		{XtNsensitive, (XtArgVal) False},
        };

/*-----------------------------------------------------*/
/* CREATION OF THE INIT					*/
/*-----------------------------------------------------*/
  void Init()
  {

/* BTN1UP = DEFAULT + RESET otherwise does not unhighlight */
/* Declaration of the translation table for init */
  static String menu_trans = "<Btn1Up>: notify() unset() reset()" ;
  XtTranslations menu_compiled ;

   XtSetArg(init_arg[3],XtNfromVert, title_simulation) ;
   XtSetArg(init_arg[5],XtNfromHoriz, lload) ;

        init = XtCreateManagedWidget(" Init ",
                                commandWidgetClass,
                                simulation,
                                init_arg,
                                XtNumber(init_arg));

/* Compilation of the translation table for init */
  menu_compiled = XtParseTranslationTable(menu_trans) ;
  XtOverrideTranslations(init, menu_compiled) ;


/* "Compile" the call back */
  XtAddCallback(init, XtNcallback,
        Choice_Init_callback,(caddr_t)init) ;


} 
