/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * GetStatus.c
 ******************************************************************************/

#include "everything.h"
#include <ctype.h>  /* This one is for N_STATE etc.. to be known here */
#include "rpcheader.h"  /* OR IS IT THIS ONE ?? */

#define rpc_free(x, p) if(p)xdr_free(x, p)

/*----------------------------------------------------------*/
/* THIS PROC CALLS THE RPC WHICH GIVES THE STATE OR ERROR */
/* 	 FOR WEIGHT SEE NEWGETWEIGHT.c 		*/
/* COMMENTS : To get the status (or whatever) you have to access */
/* 	      the RPC at the CLUSTER level */
/*----------------------------------------------------------*/

/* EXTERN for the RPC */
extern char server[] ;
extern CLIENT *myclient ;
static rec *stateres;

/* The configuration of the loaded nC neural network */
/* NB obtained via RPC call */
extern confres *conf ;

/* Global Variables => Highest and Lowest value */
static  float highest = 0 ;
static  float lowest = 0 ;


/*----------------------------------------------------------*/
/* Get the status according to the path */
/* for the time being only the state of the neuron is given */

  void Getstatus(thepath , tofill , youwant ,start_point)
  int thepath[4] ;
  float tofill[] ;
  int youwant ;  /* 0 => state , 1 => error , 2 => target */
  		/* 0 => state[0] , 1 => state[1] , 2 => state[3] */
  int start_point ; /* to know at which point to fill the array */
  {
  int i ;
  int floating_number ;
/* declaration for RPC only */
  strctname rpcpara; 

/* set the argument to be given to the RPC */
  rpcpara.indx[0] = 0;

  for (i = 0; i < 4; i++) 
    rpcpara.indx[i+1] = thepath[i]; 

/* Because of the problem of server being <defunct> when calling this RPC */
/* at the neuron level I will LATER call the RPC always at cluster level */
/* and when it will be a neuron I will allocate the cluster space and */
/* from Display.c you will find the neuron state within the cluster */

  rpcpara.indx[5] = -1;

/* change to assign to namecode only one element of the foolowing set */
/* rpcpara.namecode = N_STATE | N_ERR | N_ACC | N_WEIGHT | N_TARGET; */
  switch ( youwant )
  {
/* Tuesday 17 => WORK  */
  case 0  : rpcpara.namecode = N_STATE ;
           break ;
  case 1  : rpcpara.namecode = N_ERR ;
           break ;
  case 2  : rpcpara.namecode = N_TARGET ;
           break ;
  default : rpcpara.namecode = N_STATE ;
	    break ;
  } ; 
 
/* free before calling */
rpc_free(xdr_rec, stateres);

/* call to the RPC */
stateres = rnetstat_1(&rpcpara, myclient);

/* check the result */
/* 1- error from the client-server system */
if (stateres == NULL) 
       {
   clnt_perror(myclient, server);
   return;
       } ;

/* 2- error from the RPC itself */
if (stateres->errorn == -1) 
       {
	Error(201) ;
        return ;
       } ;

if (stateres->errorn != 0 && stateres->errorn != -1) 
	{
   /*  rnetstat_1() returned the wrong type of data which  */
   /*  shouldn't have happened.  */
	Error(201) ;
        return ;
       } ;


/* Here I should have the information in RES pointer to type rec  */
   /*  do whatever necessary  */

 floating_number = stateres->rec_u.sttwgt.farray_len ;

/* try to get the real staff ie VALUE themselves */
  for (i = 0 ; i < floating_number ; i++)
     {
     tofill[start_point] = stateres->rec_u.sttwgt.farray_val[i] ; 
     if (highest < tofill[start_point]) highest = tofill[start_point] ;
     if (lowest > tofill[start_point]) lowest = tofill[start_point] ;
     start_point++ ;
     } ; 

/* if the scale is none => put a default one */
  if (highest == lowest) highest = lowest +1 ; 
 

}

/*----------------------------------------------------------*/
/* SetToState takes 1- a path (int[4]) 			   */
/* 		    2- an array of floating already allocated */
/*            gives back the array filled with values         */
/*		set the lowest and highest value */

 void SetToState(way, togive)
 int way[4] ;
 float togive[] ;
 {
 int rpc_path[4] ;
 int net , layer , cluster , neuron ;
 int i ; 
 int total_neurons ;
 int beginning ; /* to know at which point we have to fill the array coz */
                 /* we are feeding at cluster level => more than one call */


  total_neurons = 0 ; beginning = 0 ;

 /* set it to -1 in order to have all neurons within */
/* the concerned cluster */
      rpc_path[3] = -1 ;

  switch( GiveLevel(way) )
   {
 case 0 :
/* system level => call for every net , layer and cluster */

 total_neurons = GiveTotal(0,way) ;

/* assign the array */
  for ( net = 0 ; net < conf->confres_u.sys->rpcsys_len ; net++)
   for ( layer = 0 ; 
         layer < conf->confres_u.sys->rpcsys_val[net].rpcnet_len ; 
	 layer++)
     for ( cluster = 0 ; 
    cluster < conf->confres_u.sys->rpcsys_val[net].rpcnet_val[layer].rpclay_len;
	cluster++)
      {
      rpc_path[0] = net ; rpc_path[1] = layer ; 
      rpc_path[2] = cluster ;
      Getstatus(rpc_path , togive, FindAssoc(way), beginning) ;
      beginning = GiveTotal(3,rpc_path) + beginning ;
      } ;
/* Set the highest and lowest values */
      FillNeuronScaleFamily(way , lowest , highest) ;
      break ;

 case 1 :
/* net level => call for every  layer , cluster */

 total_neurons = GiveTotal(1,way) ;
 net = way[0] ; rpc_path[0] = way[0];  net = way[0] ;

/* assign the array */
   for ( layer = 0 ; 
           layer < conf->confres_u.sys->rpcsys_val[net].rpcnet_len ; 
		layer++)
     for ( cluster = 0 ; 
    cluster < conf->confres_u.sys->rpcsys_val[net].rpcnet_val[layer].rpclay_len;
	cluster++)
      {
      rpc_path[1] = layer ; 
      rpc_path[2] = cluster ;
      Getstatus(rpc_path , togive, FindAssoc(way) , beginning) ;
      beginning = GiveTotal(3,rpc_path) + beginning ;
      } ;
/* Set the highest and lowest values */
      FillNeuronScaleFamily(way , lowest , highest) ;
      break ;

 case 2 :
/* layer level => call for every  cluster */

 total_neurons = GiveTotal(2,way) ;

     rpc_path[0] = way[0]; rpc_path[1] = way[1]; 
     net = way[0] ; layer = way[1] ;
     for ( cluster = 0 ; 
    cluster < conf->confres_u.sys->rpcsys_val[net].rpcnet_val[layer].rpclay_len;
	cluster++)
      {
      rpc_path[2] = cluster ;
/* if it is because matrix display then should look at the asssoc for net !!*/

      Getstatus(rpc_path , togive, FindAssoc(way), beginning) ;
      beginning = GiveTotal(3,rpc_path) + beginning ;
      } ;
/* Set the highest and lowest values */
      FillNeuronScaleFamily(way , lowest , highest) ;
      break ;

 case 3 :
/* cluster level => call for just one cluster */

   beginning = 0 ;
   total_neurons = GiveTotal(3,way) ;

   rpc_path[0] = way[0]; rpc_path[1] = way[1]; rpc_path[2] = way[2];

      Getstatus(rpc_path , togive, FindAssoc(way), beginning) ;
/* Set the highest and lowest values */
      FillNeuronScaleFamily(way , lowest , highest) ;

      break ;

 case 4 :
/* neuron level => call for just one neuron */
/* Thursday and Friday in October */
/*PROBLEM HERE => <defunct> process => RPC server destroyed */
/*      Getstatus(rpc_path , togive, FindAssoc(way), 0) ; */
/* 22 November changes in rpcint.c */


      Getstatus(way , togive, FindAssoc(way), 0) ; 
/* Set the highest and lowest values */
      FillNeuronScaleFamily(way , 0 , 0 ) ;
      break ;

/* End of case */
   } ;

 }

/*----------------------------------------------------------*/
/* SPECIAL for layers displayed asa matrix in the net Level window */
/* SetToMatrix State takes 1- a path (int[4]) 			   */
/* 		    2- an array of floating already allocated */
/*            gives back the array filled with values         */
/*		set the lowest and highest value */

/* way will be layers but HAS to be NET  */
/* for the association state[x] <-> colour */
 void SetToMatrix(way, togive)
 int way[4] ;
 float togive[] ;
 {
 int rpc_path[4] , matrix_way[4] ;
 int net , layer , cluster , neuron ;
 int i ; 
 int total_neurons ;
 int beginning ; /* to know at which point we have to fill the array coz */
                 /* we are feeding at cluster level => more than one call */


  total_neurons = 0 ; beginning = 0 ;

/* set matrix way to be at the net level to find the association */
  matrix_way[0] = 0 ;
  for ( i = 1 ; i < 4 ; i++)
  	matrix_way[i] = -1 ;

 /* set it to -1 in order to have all neurons within */
/* the concerned cluster */
      rpc_path[3] = -1 ;

/* layer level => call for every  cluster */

 total_neurons = GiveTotal(2,way) ;

     rpc_path[0] = way[0]; rpc_path[1] = way[1]; 
     net = way[0] ; layer = way[1] ;
     for ( cluster = 0 ; 
    cluster < conf->confres_u.sys->rpcsys_val[net].rpcnet_val[layer].rpclay_len;
	cluster++)
      {
      rpc_path[2] = cluster ;
/* if it is because matrix display then should look at the asssoc for net !!*/

      Getstatus(rpc_path , togive, FindAssoc(matrix_way), beginning) ;
      beginning = GiveTotal(3,rpc_path) + beginning ;
      } ;
/* Set the highest and lowest values */
      FillNeuronScaleFamily(way , lowest , highest) ;

}
