/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * ChangInit.c
 ******************************************************************************/

#include "everything.h"

#define rpc_free(x, p) if(p)xdr_free(x, p)
/*----------------------------------------------------------*/
/* THIS PROC CALLS THE RPC WHICH INIT A N NETWORK          */
/*  Given a file it will 1- construct the associated NNetwork */
/*		         2- call connect()			*/
/* 			 3- call build_rules()			*/
/*			 4- set the states and weights to 0     */
/*  Returns 0 if failure					*/
/*	    1 if OK 						*/
/*	    -1 if RPC reset 					*/
/*----------------------------------------------------------*/
/* At the moment dummy file */

/* EXTERN for the RPC */
extern char server[] ;
extern CLIENT *myclient ;
static int *init_result ;

/*----------------------------------------------------------*/
  int ChangInit(user_conf) 
  char *user_conf ;
  {
  fname filename ;
  int i ;

/* Assign to filename the filename the user has enter in */
/* IOTake.c */

   strcpy(filename, user_conf ); 


/* free before calling */
  rpc_free(xdr_rec, init_result);

/* call to the RPC */
  init_result = rinit_1(filename, myclient);

/* check the result */
/* 1- error from the client-server system */
  if (init_result == NULL) 
       {
   clnt_perror(myclient, server);
   return(-1);
       } ;
/* 2- failure of the RPC */
  if (*init_result== -1)
     {
     Error(202) ;
     return(0) ;
     } ;

/* Here a NNetwork is ready to be used  */
/* EXCEPT for the init of states and weights */
  return(1) ;
}
