/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * AssocFamilyFilled.c
 ******************************************************************************/

#include "myheader.h"
#include "mymonitor.h"

#define AGAIN_CAUTION 26
/* SHOULD BE THE SAME THEN IN ALL FAMILY STUFF */

/*----------------------------------------------------*/
/* THESES PROC TAKE CARE ABOUT THE FAMILY OF ASSOCIATION */
/* COLOUR <=> STATE , ERROR , TARGET 			 */
/*    NB = A PATH IS LINKED TO AN ASSOCIATION            */
/* 1- FilledAssocFamily => updates the family */
/* 2- CloseAssoc  => deletes the association from the family  */
/*----------------------------------------------------*/

typedef struct 
	{
	 int lepath[4] ; 
         int association ;
	 float weightscale[2] ; 
		/* weightscale[0] minimum ; weightscale[1] maximum */
	 float neuronscale[2] ;
		/* neuronscale[0] minimum ; neuronscale[1] maximum */
     	 float threshold ;
        } FamilyAssoc ;

FamilyAssoc theassocfamily[AGAIN_CAUTION] ;


/* Set theassoc family */

  void SetAssocFamily() 
  {
  int wid ;
  int counter ;
  assoc_session = 1 ;
  for ( wid = 0 ; wid < AGAIN_CAUTION ; wid++) 
       {
       theassocfamily[wid].association = 0 ;
       for (counter = 0 ; counter < 4 ; counter++)
        theassocfamily[wid].lepath[counter] = -2 ;
       } ;

  }

/*----------------------------------------*/
/* THIS PROC compare two paths ; same => returns 1 */
/* 				 different => returns 0 */

  int CompareRoute(route1 , route2) 
  int route1[4] ;
  int route2[4] ;
  {
   if (
      route1[0] == route2[0]  && route1[1]  == route2[1] 
       && route1[2] == route2[2]  && route1[3] == route2[3]
      )
   return(1) ;
   else return(0) ;
  }

/*----------------------------------------*/
/* THIS PROC filled the array of weight scale */

  void FillWeightScaleFamily(a_path , low , high) 
  int a_path[4] ;
  float low ;
  float high ;
  {
  int i  , count ;

  for ( count = 0 ; count < AGAIN_CAUTION ; count++) 
     {
/* it is an old entry => change the weightscale fields */
   if ( CompareRoute(theassocfamily[count].lepath, a_path) )
       {
       theassocfamily[count].weightscale[0] = low ;
       theassocfamily[count].weightscale[1] = high ;
       return ;
       } ;
/* it is a new entry  => assign the weightscale fields */
     if (theassocfamily[count].lepath[0] == -2  )
	{
       theassocfamily[count].weightscale[0] = low ;
       theassocfamily[count].weightscale[1] = high ;
       for(i=0 ; i<4 ; i++)
         theassocfamily[count].lepath[i] = a_path[i] ;
       return ;
	} ;
     } ; 
  }
/*----------------------------------------*/
/* THIS PROC according to a path gives back the array of weight scale */

  void GiveWeightScaleFamily(a_path , thescale) 
  int a_path[4] ;
  float thescale[2] ;
  {
  int count ;

  for ( count = 0 ; count < AGAIN_CAUTION ; count++) 
     {
/* it is the entry => give back the weightscale fields */
   if ( CompareRoute(theassocfamily[count].lepath, a_path) )
       {
        thescale[0] = theassocfamily[count].weightscale[0] ;
        thescale[1] = theassocfamily[count].weightscale[1] ;
       return ;
       } ;
     } ; 
  printf("Rotten Find Weight Scale\n") ;
  }

/*----------------------------------------*/
/*----------------------------------------*/
/* THIS PROC filled the array of neuron scale */

  void FillNeuronScaleFamily(a_path , low , high) 
  int a_path[4] ;
  float low ;
  float high ;
  {
  int count ;

  for ( count = 0 ; count < AGAIN_CAUTION ; count++) 
     {
/* it is an old entry => change the neuronscale fields */
   if ( CompareRoute(theassocfamily[count].lepath, a_path) )
       {
       theassocfamily[count].neuronscale[0] = low ;
       theassocfamily[count].neuronscale[1] = high ;
       return ;
       } 
/* it is a new entry  => assign the neuronscale fields */
     if (theassocfamily[count].lepath[0] == -2  )
	{
       theassocfamily[count].neuronscale[0] = low ;
       theassocfamily[count].neuronscale[1] = high ;
	} ;
     }; 
  }

/*----------------------------------------*/
/* THIS PROC according to a path gives back the array of neuron scale */

  void GiveNeuronScaleFamily(a_path , thescale) 
  int a_path[4] ;
  float thescale[2] ;
  {
  int count ;

  for ( count = 0 ; count < AGAIN_CAUTION ; count++) 
     {
/* it is the entry => give the neuronscale fields */
   if ( CompareRoute(theassocfamily[count].lepath, a_path) )
       {
        thescale[0] = theassocfamily[count].neuronscale[0] ;
        thescale[1] = theassocfamily[count].neuronscale[1] ;
       return ;
       } ;
     } ; 
  printf("Rotten Find State Scale\n") ;
  }

/*----------------------------------------*/
/* THIS PROC filled the array of association */

  void FillAssocFamily(a_path , a_number) 
  int a_path[4] ;
  int a_number ;   /* 0= state , 1= error , 2= target */
  {
  int wid , counter ;
  
  if (!assoc_session) SetAssocFamily() ; 

  for ( wid = 0 ; wid < AGAIN_CAUTION ; wid++) 
     {
/* it is an old entry => change the association field */
   if ( CompareRoute(theassocfamily[wid].lepath, a_path) )
       {
       theassocfamily[wid].association = a_number ;
       return ;
       } ;
 
/* it is a new entry  => assign the association field */
     if (theassocfamily[wid].lepath[0] == -2  )
	{
        theassocfamily[wid].association = a_number ;
/* inaccurate filling of those fields ; the correct one will be done */
/* after any call to GetWeight or GetState */
        theassocfamily[wid].neuronscale[0] = a_number ;
        theassocfamily[wid].neuronscale[1] = a_number ;
        theassocfamily[wid].weightscale[0] = a_number ;
        theassocfamily[wid].weightscale[1] = a_number ;

        for (counter = 0 ; counter < 4 ; counter++) 
          {
	  theassocfamily[wid].lepath[counter] = a_path[counter] ;
          } ;
        return ; /* get out of the for loop */
 	} ;	
    } ;
   }


/*----------------------------------------*/
/* THIS PROC deletes from thefamily  the one which has just been closed */
/* PRBE => ADD THEE WIDGET ID COZ TWO WINDOW CAN HAVE THE SAME PATH */
  void CloseAssocFamily(a_path) 
  int a_path[4] ;
  {
  int wid_nbe , compo ;
  int i , end ;

/* find the entry to be deleted */
for (wid_nbe = 0 ; wid_nbe < AGAIN_CAUTION ; wid_nbe++)
 {
   if ( CompareRoute(theassocfamily[wid_nbe].lepath, a_path) )
    end = wid_nbe ;
 }
/* Delete one entry => shift the array */
  for (wid_nbe = end +1 ; wid_nbe < AGAIN_CAUTION ; wid_nbe++)
   {
/* shift assoc number */
   theassocfamily[wid_nbe -1].association = 
		theassocfamily[wid_nbe].association;
/* shift threshold number */
   theassocfamily[wid_nbe -1].threshold = 
		theassocfamily[wid_nbe].threshold;

/* shift the paths */
  for (i = 0 ; i < 4 ; i++ )
   theassocfamily[wid_nbe -1].lepath[i] =  
      theassocfamily[wid_nbe].lepath[i]  ;
  }

 }


/*----------------------------------------*/
/* THIS PROC according to a path              */
/*      1- finds the entry according to the path  */
/*      2- Sends back the association value      */

  int FindAssoc(a_path) 
  int a_path[4] ; /* this is the path where the rule has been called from */
  {
  int wid_nbe , counter ;

/* find the entry to give the association */
/* -1 */    
for (wid_nbe = 0 ; wid_nbe < AGAIN_CAUTION ; wid_nbe++)
 {
   if ( CompareRoute(theassocfamily[wid_nbe].lepath, a_path) )
     return(theassocfamily[wid_nbe].association ) ;
  } ;

/* the association dows not exists (case when asking connection at net level*/
/* => ask for the association at the layer level (to display the connection */
/* Always retrun 0 ie colour is associated with state of neuron by default */
 return(0) ;

}


/*----------------------------------------*/
/*----------------------------------------*/
/* THIS PROC filled the array of threshold */

  void FillThreshold(a_path , value) 
  int a_path[4] ;
  float value;
  {
  int count ;

  for ( count = 0 ; count < AGAIN_CAUTION ; count++) 
     {
/* it is an old entry => change the neuronscale fields */
   if ( CompareRoute(theassocfamily[count].lepath, a_path) )
       {
       theassocfamily[count].threshold = value ;
       return ;
       } 
/* it is a new entry  => assign the neuronscale fields */
     if (theassocfamily[count].lepath[0] == -2  )
	{
       theassocfamily[count].threshold = value ;
	} ;
     }; 
  }



/*----------------------------------------*/
/* THIS PROC according to a path              */
/*      1- finds the entry according to the path  */
/*      2- Sends back the threshold value      */

  float FindThreshold(a_path) 
  int a_path[4] ; /* this is the path where the rule has been called from */
  {
  int wid_nbe , counter ;

/* find the entry to give the association */
/* -1 */    
for (wid_nbe = 0 ; wid_nbe < AGAIN_CAUTION ; wid_nbe++)
 {
   if ( CompareRoute(theassocfamily[wid_nbe].lepath, a_path) )
     return(theassocfamily[wid_nbe].threshold) ;
  } ;

/* the association dows not exists (case when asking connection at net level*/
/* => ask for the association at the layer level (to display the connection */
/* Always retrun 0 ie colour is associated with state of neuron by default */
 return(0.5) ;

}
