/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * AddInformation.c
 ******************************************************************************/

#include "myheader.h"


/* 	EXTERN 		*/
/* To change, when loaded the name of the file */
/* Need to give the parent widget in order to tell him */
/* that the child, after changes, is again managable */
/* Furthermore because loading a new file is not supported I have to */
/* DESTROY spec_simulation and create a new one CAUTION */
/* From main.c */
extern Widget overall ;
extern Widget spec_simulation ;
extern Widget status_simulation ;
extern Widget model_text ; 
extern Widget model_param ; extern Arg modelparam_arg[11] ;
extern Widget target_text ; 
extern Widget target_param ; extern Arg targetparam_arg[11] ;
extern Widget stimuli_text ;
extern Widget stimuli_param ; extern Arg stimuliparam_arg[11] ;
extern Widget init_text ;
extern Widget init_param ;  extern Arg initparam_arg[11] ;
extern Widget appli_text ;
extern Widget appli_param ;  extern Arg appliparam_arg[11] ;
extern Widget state_simu_text ;
extern Widget state_simu_text ;
extern Widget state_simu_param ; extern Arg statesimuparam_arg[11] ;

/* The new spec simulation with, now the display of the LOADED file */
Widget newspec_simulation ;

/* From nCtop.c */
extern Widget nCfakespec ;
extern Widget algo_text ;
extern Widget algo_param ; extern Arg algoparam_arg[11] ;
extern Widget config_text ;
extern Widget config_param ; extern Arg configparam_arg[11] ;

/* For current application statement being executed */
extern Widget appli_statement_text ;
extern Widget appli_statement_param ; extern Arg applistatementparam_arg[7] ;

/*----------------------------------------------*/
/* Change the info displayed in the label_param  widget*/
/* This proc. is called from IOTake.c		*/
/*		    and from Init_control.c */
/*----------------------------------------------*/
/* typeinfo = which kind of info :
 *	0 = about N or nC HLL choosen  
 * 	1 = about stimuli (i.e. input)
 * 	2 = about weights and states initialisation 
 * 	3 = about loading in the Filewidget the loaded nC file SEE LATER
 * 	4 = about state of the simulation
 * 	5 = about algorithm 
 * 	6 = about config
 * 	7 = about target machine 
 * 	8 = about application 
 * 	9 = about current statement in application
 */
void Add_information(typeinfo, thename)
int typeinfo ;     
char *thename ;
{
int *thewidth , *theheight ;

static Arg newspecsimulation_arg[] = {
                {XtNvertDistance, (XtArgVal)1},
                {XtNfile, (XtArgVal)NULL},
                {XtNfromVert, (XtArgVal)NULL},
                {XtNtextOptions, (XtArgVal)scrollVertical},
                {XtNeditType, (XtArgVal)XttextRead},
                {XtNresizable, (XtArgVal)True},
                {XtNheight, (XtArgVal)TEXTE_DISPLAY_HEIGHT},  
                {XtNwidth, (XtArgVal)SIMULATION_WIDTH},
        };

/* To use XtSetValues and not to autoresize the widget */
/* you have to set the Xtresize resource to False */

/* Comments = Get the size of the text widget (via GiveMe) in order */
/*            for the param widget to have the same size 	*/

switch (typeinfo) 
	{
  case 0 : XtUnrealizeWidget(model_param) ;
 	 GiveMe(model_text , &thewidth , &theheight) ; 
 	XtSetArg( modelparam_arg[3], XtNheight, theheight ) ; 
 	 XtSetArg( modelparam_arg[4], XtNwidth, thewidth ) ; 
	XtSetArg( modelparam_arg[1], XtNlabel, thename) ;
	XtSetValues(model_param,modelparam_arg,XtNumber(modelparam_arg));
	XtManageChild(model_param) ;
	XtRealizeWidget(status_simulation) ;
 	break ;

  case 1 : XtUnrealizeWidget(stimuli_param) ;
 	GiveMe(stimuli_text , &thewidth , &theheight) ;
 	XtSetArg( stimuliparam_arg[3], XtNheight, theheight ) ;
 	XtSetArg( stimuliparam_arg[4], XtNwidth, thewidth ) ;
 	XtSetArg( stimuliparam_arg[1], XtNlabel, thename) ;
	XtSetValues(stimuli_param,stimuliparam_arg,XtNumber(stimuliparam_arg));
	XtManageChild(stimuli_param) ;
	XtRealizeWidget(status_simulation) ;
 	break ;

  case 2 : XtUnrealizeWidget(init_param) ;
 	GiveMe(init_text , &thewidth , &theheight) ;
 	XtSetArg( initparam_arg[3], XtNheight, theheight ) ;
 	XtSetArg( initparam_arg[4], XtNwidth, thewidth ) ;
 	XtSetArg( initparam_arg[1], XtNlabel, thename) ;
	XtSetValues(init_param,initparam_arg,XtNumber(initparam_arg));
	XtManageChild(init_param) ;
	XtRealizeWidget(status_simulation) ;
 	break ;

  case 4 : XtUnrealizeWidget(state_simu_param) ;
 	GiveMe(state_simu_text , &thewidth , &theheight) ;
 	XtSetArg( statesimuparam_arg[3], XtNheight, theheight ) ;
 	XtSetArg( statesimuparam_arg[4], XtNwidth, thewidth ) ;
 	XtSetArg( statesimuparam_arg[1], XtNlabel, thename) ;
 XtSetValues(state_simu_param,statesimuparam_arg,XtNumber(statesimuparam_arg));
	XtManageChild(state_simu_param) ;
	XtRealizeWidget(status_simulation) ;
 	break ;

  case 5 : XtUnrealizeWidget(algo_param) ;
 	GiveMe(algo_text , &thewidth , &theheight) ;
 	XtSetArg( algoparam_arg[3], XtNheight, theheight ) ;
 	XtSetArg( algoparam_arg[4], XtNwidth, thewidth ) ;
 	XtSetArg( algoparam_arg[1], XtNlabel, thename) ;
 XtSetValues(algo_param,algoparam_arg,XtNumber(algoparam_arg));
	XtManageChild(algo_param) ;
	XtRealizeWidget(nCfakespec) ;
 	break ;
/* Following not supported by XtoolKit, namely Setvalues on a file */
/* Therfore DESTROY and CREATE AGAIN */
/*		 XtUnrealizeWidget(spec_simulation) ;
 *		XtSetArg( arg[1], XtNfile, "junk.nC") ;
 *		XtSetValues( spec_simulation, arg, 2) ;
 *		XtManageChild(model_param) ;
 *		XtRealizeWidget(status_simulation) ;
*/


  case 6 : XtUnrealizeWidget(config_param) ;
 	GiveMe(config_text , &thewidth , &theheight) ;
 	XtSetArg( configparam_arg[3], XtNheight, theheight ) ;
 	XtSetArg( configparam_arg[4], XtNwidth, thewidth ) ;
 	XtSetArg( configparam_arg[1], XtNlabel, thename) ;
 XtSetValues(config_param,configparam_arg,XtNumber(configparam_arg));
	XtManageChild(config_param) ;
	XtRealizeWidget(nCfakespec) ;
 	break ;

  case 7 : XtUnrealizeWidget(target_param) ;
 	GiveMe(target_text , &thewidth , &theheight) ;
 	XtSetArg( targetparam_arg[3], XtNheight, theheight ) ;
 	XtSetArg( targetparam_arg[4], XtNwidth, thewidth ) ;
 	XtSetArg( targetparam_arg[1], XtNlabel, thename) ;
 XtSetValues(target_param,targetparam_arg,XtNumber(targetparam_arg));
	XtManageChild(target_param) ;
	XtRealizeWidget(status_simulation) ;
 	break ;

  case 8 : XtUnrealizeWidget(appli_param) ;
 	GiveMe(appli_text , &thewidth , &theheight) ;
 	XtSetArg( appliparam_arg[3], XtNheight, theheight ) ;
 	XtSetArg( appliparam_arg[4], XtNwidth, thewidth ) ;
 	XtSetArg( appliparam_arg[1], XtNlabel, thename) ;
 XtSetValues(appli_param,appliparam_arg,XtNumber(appliparam_arg));
	XtManageChild(appli_param) ;
	XtRealizeWidget(status_simulation) ;
 	break ;

  case 9 : XtUnrealizeWidget(appli_statement_param) ;
 	XtSetArg( applistatementparam_arg[1], XtNlabel, thename) ;
 XtSetValues(appli_statement_param,applistatementparam_arg,XtNumber(applistatementparam_arg));
	XtManageChild(appli_statement_param) ;
	XtMapWidget(appli_statement_param) ;
	XtRealizeWidget(overall) ;
 	break ;

  case 3 :XtDestroyWidget(spec_simulation) ;
	/* instead of junk.nC should have thename it has been tested and */
	/* it works but because I just have one X.nC file I always load it*/
    	XtSetArg(newspecsimulation_arg[1],XtNfile, thename ) ;
 	XtSetArg(newspecsimulation_arg[2],XtNfromVert, appli_statement_text);
        spec_simulation = XtCreateManagedWidget("spec",
                                asciiDiskWidgetClass,
                                overall,
                                newspecsimulation_arg,
                                XtNumber(newspecsimulation_arg));
	XtRealizeWidget(overall) ;
	break ;

	} 

}
