.TH PGM 1 "March 1990" "Beta Test v1.02" 
.SH NAME
pgm \- Esprit Project 2059, Pygmalion Graphic Monitor.
.SH SYNOPSIS
.B pgm 
[ \fI-toolkitoption ... \fP] 

.SH DESCRIPTION
\fIPGM\fP is a graphical neural network programming environment, running
under X11 releases 3 or 4 (see the document on Pygmalion Programming
Environment). The environment can support different high level languages
and can execute the neural network system on different machines, by using
a Remote Procedure Call (RPC) mechanism.  At the present time only the
C-based programming language, \fBnC\fP is supplied.  Visual feedback and
mouse (or keyboard) input gives the user a way to examine and control a
neural network system execution while the
\fBnC\fP high level language allows the user to create and modify a neural
network system within \fIPGM\fP


.SH WINDOWS
\fIPGM\fP is made up of the following windows:
.IP "Top Windows" 20
These provide control and status information for the overall use of the
Pygmalion Graphic Monitor facilities. There is a standard Window, plus
one dedicated to functions specific to the High Level Language chosen.
.IP "Level Windows"
These provide control and status information for each specific level of the
\fRnC\fP neural network system ie. system, net, layer, cluster, neuron and
synapses (see nC specification document). The user can control the creation
of these Level Windows.

.SH WINDOW AREAS
.LP
\fIThe Standard Top Window\fP is made up of the following areas:
.RS
.IP "Command Area" 20
Provides control over the \fIPGM\fP facilities.
.IP "Parameter Area" 20
Presents status information used by the commands. 
.IP "Textual Area" 20
Displays the \fBnC\fP application specification if one has been specified, 
otherwise current neural network topology.
.RE
.LP
The \fInC\fR specific HLL window has just Command and Parameter areas.
.RE
.LP
\fIEach Level Window\fP consists of the following areas :
.RS
.IP "Command-Rule area" 20
Interactive control of the execution of the neural network system at 
the specific level, via buttons.
.IP "Graphic area" 20
Display a graphical view of the specific level and its pattern of 
intra-connectivity.
The Graphic area menu can be obtained by clicking the left mouse button
in this area.
.IP "Parameter area" 20
Complements the information displayed within Graphic area.
.RE

.sp 3
.SH MAIN TOP WINDOW : COMMANDS 
.sp 1
.LP
.IP "\fBHLL\fP" 10
Allows you to select a high level language.
.sp 1
.LP
.IP "\fBTarget\fP" 10
Allows you to select the target machine on which the neural network will
be executed
.sp 1 
.LP
.IP "\fBTraining Set\fP" 10
Load a set of patterns described within a pattern descriptors file which
contains a pair of (input , target) patterns per line.  To access this
command a neural network system must have been selected; ie. select an
algorithm and then load either a trained or partially trained system or a
configuration.
.sp 1 
.LP
.IP "\fBRun\fP" 10
Start an interactive simulation by displaying a system or net Level
Window.  To do this an algorithm and a configuration/system must have
been chosen.
.sp 1 
.LP
.IP "\fBPause\fP" 10
Pause the simulation. Not implemented in the beta release.
.sp 1
.LP
.IP "\fBLoad\fP" 10
Load, from a file, a trained or partially trained neural network system.
To access this command a neural network algorithm must have been selected.
.sp 1
.LP
.IP "\fBSave\fP" 10
Save to a file, a trained or partially trained neural network system.
Later on, this saved system can be loaded via the "load" command; for
instance  to continue the training process.
.sp 1
.LP
Init command
.RS
.LP
The following facilities are not provided within this release.
.LP
.IP "\fBweights initialisation\fP" 10
Initialise the weights from a file specifying all the weights in
a certain format.
.IP "\fBstates initialisation\fP" 10
Initialise the states from a file specifying all the states in
a certain format.
.IP "\fBweights and states initialisation\fP" 10
Initialise the states and the weights from a formatted file.
.RE
.sp 1
.LP
.SS "Quit"
Exit \fIPGM\fP
.sp 3
.SH nC SPECIFIC WINDOW 
.sp 1
.LP
.IP "\fBAlgorithm\fP" 10 
Select an algorithm from the set of algorithms in the library.
The user is allowed to include his own algorithm (See Pygmalion Graphic
Monitor reference manual).
.sp 1
.LP
.IP "\fBEditor\fP" 10
Call up a editor window from within \fIPGM\fR.  The choice of editor is
determined by the environment variable EDITOR.
.sp 1
.LP
.IP "\fBConfiguration\fP" 10
Enter, as a file, a neural network configuration; number of nets, 
number of layers wihtin each net ...etc.
To access this command a neural network algorithm must have been selected.
.sp 1
.LP
.IP "\fBGenerate ILL\fP" 10
Generates from the nC specification the correspondant nC-code 
specification. Not provided in this release.
.sp 1
.LP
.IP "\fBQuit nC\fP" 10
Exit from the \fBnC\fR specific window.
.sp 3
.LP
.SH LEVEL WINDOWS : 
.sp 1
.LP
.SH COMMAND-RULE AREA
.sp 1
.SS "Windows Management Commands"
.LP
These commands are made available by clicking in the level
specific title bar of the window.
.LP
.IP "\fBOpen\fP" 10
Open a Level window at the level specified by using menus.
These menus allow the user to specify the level by setting the name of
the components. For example, to open a layer window, the user should
specified the name of the net and the layer he wishes to open.
.sp 1
.LP
.IP "\fBClose\fP" 10
Quit the current Level window.
.sp 1
.LP

.SS "Rule Execution Commands"
Execute the named neural network rule at the specific level. If the execution
of the rule needs any patterns the user will be asked to select it from the
patterns descriptors that he has previously loaded.
.sp 1
.LP
.SH GRAPHIC AREA MENU
.sp 1
.IP "\fBMagnify\fP" 10
Magnify a part of the screen.  This function currently just calls the
standard X Windows utility \fIxmag\fR.
.LP
.sp 1
.IP "\fBColourscale\fP" 10
Change the colour scale; ie change the association colour <-> lowest value and
colour <-> highest value. A grey scale is available.
This function is only available when running \fIpgm\fR with a colour
monitor.
.LP
.sp 1
.IP "\fBAssoc colour\fP" 10
Modify the association colour<->state[] of a neuron. Set to be colour<->state[0]
by default.
For colour version of PGM only.
.LP
.sp 1
.IP "\fBThreshold\fP" 10
Available only when running \fIPGM\fR on a monochrome display.  Allows to
change the threshold value for separating black and white colours (set to
0.5 by default).
.LP
.sp 1
.IP "\fBdisplay connection\fP" 10
Display a connectivity matrix between two components. Components are layers
for a net Level Window, clusters for a layer Level Window, neurons for a 
cluster Level Window. The user specifies the components via menus.
.LP
.sp 1
.IP "\fBremove display connection\fP" 10
Remove the current display of connectivity matrix.
.LP
.sp 1
.IP "\fBmatrix display\fP" 10
Modify the graphic display of the input and output layers from linear to
matrix.  Only accessible at the net level.
.IP "\fBremove matrix display\fP" 10
Return back to linear display. This command is only accessible at the net level.
.LP
.sp 2
.LP
.SH PARAMETERS AREA
.SS "Parameters Commands"
Record the values of a parameter throughout the simulation, and display
in histogram form.  Not provided with this release.


.SH SEE ALSO
\fBPGM\fR Tutorial, \fBPGM\fR Reference Manual, nC specification document
and Pygmalion Software Environment Overview document.  Relevant paper:
"PYGMALION Neural Network Programming Environment", [Azema-Barac,
Hewetson, Recce, Taylor, Treleaven, Vellasco] January 1990 UCL-CS
.SH LIMITATIONS
\fIPGM\fP is  the beta test site release of the Pygmalion software environment 
and therefore
contains a limited number of facilities. It should be noted that 
the system is under continuous development and will be enhanced and optimised.
Users are encouraged to enhance \fBpgm\fP themselves.
.SH BUGS
We've fixed many, know about others - but if you find more, please tell
us so we can fix them!
.LP
.SH COPYRIGHT
Copyright March 1990, Department of Computer Science, University College London. 
All copyrights and trademarks with respect to X Windows acknowledged.
.SH AUTHOR
Magali Azema-Barac, Mike Hewetson
