#include <stdio.h>
#include <string.h>
#include "std.h"
#include "utils.h"

extern P_NAME_ENTRY **hashtab[MAX_LAYERS];
extern int hashsize[MAX_LAYERS];

hash(s,l)
char *s;
int l;
{ int hashval;

  for (hashval = 0; *s != '\0';)
     hashval += *s++;
  return (hashval % hashsize[l]);
}

boolean clamped_high(word)
char word[];
{int pos_asterix;
   pos_asterix = strlen(word)-2;
   return (strcmp(&word[pos_asterix],"*1") == MATCH);
}

boolean clamped_low(word)
char word[];
{int pos_asterix;
   pos_asterix = strlen(word)-2;
   return (strcmp(&word[pos_asterix],"*0") == MATCH);
}

initialise_weights(w,pi,init_value,max_p,curr_p)
/* This initialises the weight from 'pi' to all other units */
/* The weight from 'pi' to itself is always initialised to '0' */
int w[],init_value;
int max_p, curr_p, pi;
{int pj,wi;

    wi = pi*max_p;
    for (pj = 0; pj < curr_p; pj++)
      w[wi + pj] = w[pj*max_p + pi] = init_value;

    w[wi + pi] = 0;
}

int find_or_create_unit(p_name_tbl,name, find_or_what,curr_pp, createdp, max_p,l)
/* Returns 'pi' */
char name[];
P_NAME_ENTRY *p_name_tbl[];
int find_or_what; 
boolean *createdp; /* If this is FALSE, return the value 'NOT_FOUND'
			   if name not found */
int *curr_pp, max_p;
{int pos_asterix, hashval;
 char p_name[WORD_SIZE];
 P_NAME_ENTRY *np;

 /* Strip clamping symbols, ie '*1' or '*0' */
 pos_asterix = strlen(name)-2;
 strcpy(p_name,name);
 if (name[pos_asterix] == '*') p_name[pos_asterix] = '\0';

 if (find_or_what != CREATE_ONLY) {
   for (np = hashtab[l][hash(p_name,l)]; np != NULL; np = np->next)
     if (strcmp(p_name,np->name) == MATCH) {
       *createdp = FALSE;
       return (np->index);
     }
 }

 if ((find_or_what == FIND_ONLY) || ((*curr_pp) == (max_p -1))) {
    *createdp = TRUE;
    return NOT_FOUND;
 }

 np = (P_NAME_ENTRY *) malloc(sizeof (*np));
 np->index = (*curr_pp);
 np->name  = strsave(p_name);
 hashval   = hash(np->name,l);
 np->next  = hashtab[l][hashval];
 hashtab[l][hashval] = np;
 p_name_tbl[(*curr_pp)] = np;
 (*curr_pp)++;
 p_name_tbl[(*curr_pp)] = NULL;
 *createdp = TRUE;
 return (np->index);
}


