/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/* Xsupport.h */
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Dialog.h>
#include <X11/Text.h>

#define error1(x) fprintf(stderr,x)
#define error2(x,y) fprintf(stderr,x,y)

typedef struct bu_li
{				/* for radio box */
  Widget * toggle_list;		/* pointer to array of button ids */
  int count;			/* number of buttons */
  XtCallbackProc func;		/* button function */
} button_list;

extern Widget AddBox(/* w,s */);
/* w is the parent,
   and s is the name of the box.
     Widget w;
     char *s; */

extern Widget AddButton(/* w,s,f,d */);
/* w is the parent,
   s is the name of the button,
   f is the function to call,
   and d is the data passed to the function.
     Widget w;
     char *s;
     XtCallbackProc f;
     caddr_t d; */

extern Widget AddToggle(/* w,s,f1,f2,d1,d2 */);
/* w is the parent,
   s is the name of the button,
   f1 is the function to call on select,
   f2 is the function to call on release,
   d1 is the select function data,
   and d2 is the release function data. 
     Widget w;
     char *s;
     XtCallbackProc f1, f2;
     caddr_t d1, d2; */

extern Widget AddForm(/* w,s */);
/* w is the parent,
   and s is the name of the form.
     Widget w;
     char *s; */

extern Widget AddRadio(/* w,s,f,b */);
/* w is parent widget,
   s is the name of the radio box,
   f is the function to call,
   and b is a (null-terminated) array of button labels. 
	Widget w;
	char *s;
	XtCallbackProc f;
	char **b; */

extern Widget AddText(/* w,s,f */);
/* w is parent widget,
   s is the text to add,
   and f is the alignment (format).
     Widget w;
     char *s;
     XtJustify f; */

extern Widget AddTextEdit(/* w,n,s */);
/* w is the parent widget,
   n is the name of the TextEdit widget,
   and s is the initial text.
	Widget w;
	char *n;
	char *s; */

extern void Stub (/* w, client_data, call_data */);
/*	Widget w;
	caddr_t client_data;
	caddr_t call_data; */

extern XImage *MakeImage(/* w, bits, width, height */);
/*	Widget w;
	char *bits;
	int width, height; */

extern void SetValue(/* w,name,value */);
/* Easy interface to XtSetValues
        Widget w;
        String name;
        XtArgVal value; */

/* Suntool-like support */

extern Widget panel_create(/* parent, name, height, width */);
/*     Widget parent;
     char *name;
     int  height, width; */


extern Widget panel_item(/* parent, name, cols */);
/* creates a RowCol widget with cols columns.
     Widget parent;
     char *name;
     int  cols; */
